/*
 Copyright (C) 2002 Andreas Thiede ( a.thiede@berlin.de )

 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#if ! defined _XTV_AUDIO_BUFFER_LIST_HPP
#define _XTV_AUDIO_BUFFER_LIST_HPP

/*
 *
 */

/* forward */ class IOBuffer;

#include <IO/Manager/IOObject.hpp>
#include <list>

class IOBufferList : public IOObject {
        
        
    public:

        static IOBufferList * create();
                        
        virtual int 	   pushBack( IOBuffer * );
        virtual int        pushBack(  const char * data, int size );
        virtual IOBuffer * popFront( int milisecs = -1 );
        virtual size_t     size();
        
    private:
    
        list<IOBuffer*>	  mBuffers;
        int               mBlockNumber;
        
    protected:
        
        IOBufferList();
        IOBufferList( const IOBufferList & );
        virtual void operator=(const IOBufferList & );

    protected:
        virtual ~IOBufferList();

    private:

        void  init();
        void finit();
};


#endif // _XTV_AUDIO_BUFFER_LIST_HPP