/*
 Copyright (C) 2002 Andreas Thiede ( a.thiede@berlin.de )

 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#if ! defined _XTV_AUDIO_BUFFER_HPP
#define _XTV_AUDIO_BUFFER_HPP

/*
 *
 */

#include <IO/Manager/IOObject.hpp>

class IOBuffer : public IOObject {
        
        
    public:
                        
        static IOBuffer * initWithBuffer       (  const char * buf, int size, int nr = 0 );
        static IOBuffer * initWithPointer      (  const char * buf, int size, int nr = 0 );
        static IOBuffer * initWithConstPointer (  const char * buf, int size, int nr = 0 );
    
        virtual char   * getData() const;
        virtual size_t   getSize() const;
        virtual int      getNumber() const;

#if DEBUG_IO
        virtual void setNameFromNr();
#endif

    private:
    
        char * mData;
        int    mSize;
        int    mNr;
        int    mDelete;


    protected: // should be really private
        
        IOBuffer();

        IOBuffer( const IOBuffer & );
        virtual void operator=(const IOBuffer & );

    protected:
        virtual ~IOBuffer();

    private:

        void  init();
        void finit();

};


#endif // _XTV_AUDIO_BUFFER_HPP