/*
 Copyright (C) 2002 Andreas Thiede ( a.thiede@berlin.de )

 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include <IO/Manager/IOBuffer.hpp>
#include <assert.h>

IOBuffer::IOBuffer()
    : IOObject( "", "IOBuffer" )
{
}

IOBuffer::IOBuffer( const IOBuffer & )
    : IOObject( "", "IOBuffer" )
{
    assert( "not implemented yet" == 0 );
}

void IOBuffer::operator=(const IOBuffer & )
{
    assert( "not implemented yet" == 0 );
}

char * IOBuffer::getData() const
{
    return mData;
}

size_t IOBuffer::getSize() const
{
    return mSize;
}

int  IOBuffer::getNumber() const
{
    return mNr;
}

void IOBuffer::init()
{
    mData   = 0;
    mSize   = 0;
    mNr     = 0;
    mDelete = false;
}

void IOBuffer::finit()
{
    //printf("IOBuffer::finit %s delete data is %d\n", getName().c_str(), mDelete );
    
    if( mDelete ) {
        delete mData;
    }

    //printf("IOBuffer::finit leaving\n" );
}

#if DEBUG_IO

void IOBuffer::setNameFromNr()
{
    char num[128];
    
    if( ! getName().empty() ) {
        sprintf( num,  "%s %x", getName().c_str(), mNr );
    }
    else {
        sprintf( num,  "%x", mNr );
    }
    
    setName( num );
}
#endif

/* static */ IOBuffer * IOBuffer::initWithConstPointer(  const char * buf, int size, int nr )
{
    IOBuffer * b = new IOBuffer();

    b->mData   = (char*) buf;
    b->mDelete = false;
    b->mSize   = size;
    b->mNr     = nr;

#if DEBUG_IO

    b->setName( name );

    b->setNameFromNr();

#endif
    
    return b;
}

/* static */ IOBuffer * IOBuffer::initWithPointer( const char * buf, int size, int nr )
{
    IOBuffer * b = new IOBuffer();

    b->mData   = (char*) buf;
    b->mDelete = true;
    b->mSize   = size;
    b->mNr     = nr;

#if DEBUG_IO

    b->setName( name );

    b->setNameFromNr();

#endif
    
    return b;
}

/* static */ IOBuffer * IOBuffer::initWithBuffer ( const char * buf, int size, int nr )
{
    IOBuffer * b = new IOBuffer();

    b->mData   = new char [ size ];
    b->mDelete = true;
    b->mSize   = size;
    b->mNr     = nr;
    
    
    memcpy( b->mData, buf, size );

#if DEBUG_IO

    b->setName( name );

    b->setNameFromNr();

#endif
    
    return b;
}
        
IOBuffer::~IOBuffer()
{
    finit();
}

