/*
 Copyright (C) 2002 Andreas Thiede ( a.thiede@berlin.de )

 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#if ! defined _XTV_TELE_TEXT_INPUT_HPP
#define _XTV_TELE_TEXT_INPUT_HPP

#include <IO/Manager/IOInput.hpp>
#include <IO/Manager/IOThread.hpp>
#import <lib/aletv_vbi.h>

class TeleTextInput : public IOInput {

    public:
    
        struct VTPage {
        
            public:
                vt_page page;
                int     channel;
        };

    public:

        TeleTextInput( const string & aName, IODeviceID anId );
    
        virtual ~TeleTextInput();
    
        virtual bool start();
        virtual bool stop();

        virtual size_t frameSize();
        
    private:

        void init();
        void finit();
    
        unsigned   mVBIBufferSize;
        char     * mVBIBuffer;
        int        mCurrentChannel;
        IOThread   mWorkThread;

        void grab();
 
        void handleVBIEvent( vt_event * event );

        static void vbiCallback( TeleTextInput * _this, vt_event * event );
       
        friend void * teleTextThreadEntry( void * _this );

};

#endif // _XTV_TELE_TEXT_INPUT_HPP