/*
 Copyright (C) 2002 Andreas Thiede ( a.thiede@berlin.de )

 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#if ! defined _XTV_QT_INPUT_HPP
#define _XTV_QT_INPUT_HPP

#include <IO/Manager/IOInput.hpp>
#include <IO/Manager/IOThread.hpp>
#include <QuickTime/QuickTime.h>

/* forward */ class VideoPlayer;
/* forward */ class AudioPlayer;

class QTInput : public IOInput {

    public:

        QTInput( const string & aName, IODeviceID anId );
    
        virtual ~QTInput();
    
        virtual bool start();
        virtual bool stop();

        virtual size_t frameSize();

        virtual bool command( const string & command, 
                              const string & param1 = "", const string & param2 = "", 
                              const string & param3 = "", const string & param4 = "" );
       
        virtual string getValue( const string & valueName );
        
        virtual bool isPlaying();

        virtual bool openMovie();

        virtual OSErr playAt( TimeValue atTime );

        virtual unsigned getCurrentMovieTime();
        virtual unsigned getMovieDuration();
        
        virtual bool isMovieDone();
        
    private:

        
        void init();
        void finit();

        void update();

        virtual void closeMovie();

        static pascal OSErr movieDrawProc( Movie movie, long refcon);
        
        string                   mFileName;
        string                   mVideoOutputName;
        IOStream *               mVideoStream;
        Movie                    mQTMovie;
        short                    mResRefNum;
        short                    mResFile;
        Rect                     mMovieBox;
        TimeValue                mMovieDuration;
        GWorldPtr                mMovieGWorld;
        char                   * mVideoBuffer;
        MovieDrawingCompleteUPP  mMovieDrawUPP;
        float                    mCurrentRate;
        bool                     mStepping;
        
        friend void * qtPlayerThreadEntry( void * _this );

};

#endif // _XTV_QT_INPUT_HPP