/*
 Copyright (C) 2002 Andreas Thiede ( a.thiede@berlin.de )

 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include <IO/Input/MacAudioInput.hpp>
#include <IO/Output/IOAudioOutput.hpp>
#include <IO/Manager/IOManager.hpp>
#include <IO/osx/AudioHardware.hpp>

#import <util/Loader.h>

#include <CoreAudio/AudioHardware.h>

MacAudioInput::MacAudioInput( const string & aName, IODeviceID anID )
 : IOAudioInput( aName, anID )
{
    init();
}

MacAudioInput::~MacAudioInput()
{
    finit();
}


bool MacAudioInput::start() 
{ 
    printf("MacAudioInput::start isAttached(%d)\n", isAttached() );

    if( mInited && ! mStarted && isAttached() && AudioHardware::start( IODescription::ioIn, getDeviceID(), this ) ) {

        printf("MacAudioInput::start started(%s)\n", getName().c_str() );

        mStarted = true;
    }
    return mStarted;
}

bool MacAudioInput::stop() 
{ 
    if( mStarted && AudioHardware::stop( IODescription::ioIn, getDeviceID(), this ) ) {

        printf("MacAudioInput::stop stopped(%s)\n", getName().c_str() );
        mStarted = false;
    }
    return mStarted;
}

size_t MacAudioInput::frameSize()
{
    return 8192;
}

bool MacAudioInput::setVolume( int   l, int r   )
{
    //AudioHardware::stop( IODescription::ioIn, getDeviceID(), this );

    bool ret = AudioHardware::setVolume( getDeviceID(), l, r, true );

    printf("MacAudioInput::setVolume for(%s) is(%d,%d) ret(%d)\n",
            getName().c_str() , l, r, ret );
        
    //AudioHardware::start( IODescription::ioIn, getDeviceID(), this );
    
    return ret;
}

bool MacAudioInput::getVolume( int & l, int &r  )
{
    bool ret = AudioHardware::getVolume( getDeviceID(), l, r, true );
    
    printf("MacAudioInput::getVolume for(%s) is(%d,%d) ret(%d)\n",
            getName().c_str() , l, r, ret );

    return ret;
}

bool MacAudioInput::playThrough( IOAudioOutput * out )
{
    AudioHardware::SetHWPlayThru( getDeviceID(), 1, true );
    AudioHardware::SetHWPlayThru( getDeviceID(), 2, true );
    
    return false;
}

void MacAudioInput::init()
{
    if( AudioHardware::init( IODescription::ioIn, getDeviceID(), 8192, 2, this ) != true ) { 	
        printf( "MacAudioInput::init failed to initialize %s\n", getName().c_str());
    }
    else {
        mInited = true;
    }
}

void MacAudioInput::finit()
{
    if( AudioHardware::finit( IODescription::ioIn, getDeviceID()) != true ) { 	
        printf( "MacAudioInput::finit failed to finitialize %s\n", getName().c_str());
    }
    IOManager::instance().unregisterNode ( this );
}

bool MacAudioInput::command( const string & command, 
                             const string & param1, const string & param2, const string & param3, const string & param4 )
{
    printf("MacAudioInput::command for(%s) is(%s) param1(%s)\n",
            getName().c_str() , command.c_str() , param1.c_str() );

    if( command == "setVolume" ) {

        int l = atoi( param1.c_str() );
        int r = atoi( param1.c_str() );

        return setVolume( l, r );

    }
    else if( command == "incVolume" ) {

        int l,r;
        
        getVolume( l, r );

        l += atoi( param1.c_str() );
        r += atoi( param1.c_str() );

        return setVolume( l, r );

    }
    else if( command == "decVolume" ) {

        int l,r;

        getVolume( l, r );
        
        l -= atoi( param1.c_str() );
        r -= atoi( param1.c_str() );
        
        return setVolume( l, r );
    }
   else if( command == "leftVolume" ) {

        int l,r;
        
        getVolume( l, r );

        l = atoi( param1.c_str() );
        
        return setVolume( l, r );
        
    }
   else if( command == "rightVolume" ) {

        int l,r;
        
        getVolume( l, r );

        r = atoi( param1.c_str() );
        
        return setVolume( l, r );
    }
    
    return false;
}
