/*
 Copyright (C) 2002 Andreas Thiede ( a.thiede@berlin.de )

 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#if ! defined _XTV_IO_VIDEO_INPUT_HPP
#define _XTV_IO_VIDEO_INPUT_HPP

#include <IO/Manager/IOInput.hpp>
#include <IO/Manager/IOThread.hpp>
#include <IO/Manager/IOView.hpp>

class IOVideoInput : public IOInput, public IOView {

    public:

        IOVideoInput( const string & aName, IODeviceID anId );
    
        virtual ~IOVideoInput();
    
        virtual bool start();
        virtual bool stop();

        virtual bool command( const string & command, 
                              const string & param1 = "", const string & param2 = "", 
                              const string & param3 = "", const string & param4 = "" );

        virtual void updateFrom( IOModel * );

        virtual string getValue( const string & valueName );

        virtual size_t frameSize();
        
        virtual bool isGrabbing();
        
    private:

        void init();
        void finit();
    
        void LoadSettings();

        unsigned   mVideoBufferSize;
        char     * mVideoBuffer;
        unsigned   mAudioBufferSize;
        char     * mAudioBuffer;
        int        mCurrentChannel;
        int        mTuneOffset;
        IOThread   mWorkThread;
        
        void grab();
        
        friend void * videoThreadEntry( void * _this );

};

#endif // _XTV_IO_VIDEO_INPUT_HPP