/*
 Copyright (C) 2002 Andreas Thiede ( a.thiede@berlin.de )

 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#if ! defined _XTV_IO_BTAUDIO_INPUT_HPP
#define _XTV_IO_BTAUDIO_INPUT_HPP

#include <IO/Input/IOAudioInput.hpp>
#include <IO/Manager/IOThread.hpp>

class BtAudioInput : public IOAudioInput {

    public:

        BtAudioInput( const string & aName, IODeviceID anId );
    
        virtual ~BtAudioInput();
    
        virtual bool start();
        virtual bool stop();

        virtual size_t frameSize();

        virtual bool setVolume( int   l, int r   );
        virtual bool getVolume( int & l, int &r  );

        virtual bool playThrough( IOAudioOutput * );

        virtual bool isGrabbing();
        
    private:

        void init();
        void finit();

        void grab();
        
        friend void * btAudioThreadEntry( void * _this );

        IOThread   mWorkThread;

};

#endif // _XTV_IO_BTAUDIO_INPUT_HPP