/*
 Copyright (C) 2002 Andreas Thiede ( a.thiede@berlin.de )

 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include <IO/Input/IOVideoInput.hpp>
#include <IO/Input/BtAudioInput.hpp>
#include <IO/Input/TeleTextInput.hpp>
#include <IO/Manager/IOManager.hpp>
#include <IO/Manager/IOBuffer.hpp>
#include <IO/Manager/IOModel.hpp>
#include <IO/osx/TVHardware.hpp>
#import <util/Loader.h>

static void initBtAudioInput()
{
    TVHardware & hw = TVHardware::instance();
    
    TVHardware::List & hwList = hw.getList();
    
    TVHardware::List::Iterator iter = hwList.begin();
    
    while( iter != hwList.end() ) {
    
        IODescription * d = (IODescription*) (*iter);

        if( d->getDirection() == IODescription::ioIn && strstr( d->getName().c_str(), "Audio" ) ) {

            printf( "initBtAudioInput: adding Device(%s) id(%d)\n", d->getName().c_str(), d->getDeviceID() );

            string name = d->getName();
            
            BtAudioInput * device = new BtAudioInput( d->getName(), d->getDeviceID() );
            
            IOManager::instance().registerNode( device );
        }
        
        
        iter++;
    }

}

static void initVideoInput()
{
    TVHardware & hw = TVHardware::instance();
    
    TVHardware::List & hwList = hw.getList();
    
    TVHardware::List::Iterator iter = hwList.begin();
    
    while( iter != hwList.end() ) {
    
        IODescription * d = (IODescription*) (*iter);

        if( d->getDirection() == IODescription::ioIn && strstr( d->getName().c_str(), "Video" ) ) {

            printf( "initVideoInput: adding Device(%s) id(%d)\n", d->getName().c_str(), d->getDeviceID() );

            string name = d->getName();
            
            IOVideoInput * device = new IOVideoInput( d->getName(), d->getDeviceID() );
            
            IOManager::instance().registerNode( device );
        }
        
        
        iter++;
    }

}


static void initTeleTextInput()
{
    TVHardware & hw = TVHardware::instance();
    
    TVHardware::List & hwList = hw.getList();
    
    TVHardware::List::Iterator iter = hwList.begin();
    
    while( iter != hwList.end() ) {
    
        IODescription * d = (IODescription*) (*iter);

        if( d->getDirection() == IODescription::ioIn && strstr( d->getName().c_str(), "TeleText" ) ){

            printf( "initTeleTextInput: adding Device(%s) id(%d)\n", d->getName().c_str(), d->getDeviceID() );

            TeleTextInput * device = new TeleTextInput( d->getName(), d->getDeviceID() );
            
            IOManager::instance().registerNode( device );
        }
        
        
        iter++;
    }

}


extern "C" int initBt8xxPlugin( int argc, const char ** argv )
{
    initVideoInput();
    initBtAudioInput();
    //initTeleTextInput();

    return true;
}


