/*
 Copyright (C) 2002 Andreas Thiede ( a.thiede@berlin.de )

 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include <IO/Input/MacAudioInput.hpp>
#include <IO/Output/IOAudioOutput.hpp>
#include <IO/osx/AudioHardware.hpp>
#include <IO/Manager/IOManager.hpp>

#import <util/Loader.h>

static void initAudioInput()
{
    AudioHardware & hw = AudioHardware::instance();
    
    AudioHardware::List & hwList = hw.getList();
    
    AudioHardware::List::Iterator iter = hwList.begin();
    
    while( iter != hwList.end() ) {
    
        IODescription * d = (IODescription*) (*iter);

        if( d->getDirection() == IODescription::ioIn ){

            string name = d->getName();
            
            name += " input";
            
            printf( "initAudioInput: adding Device(%s) id(%d)\n", name.c_str(), d->getDeviceID() );

            MacAudioInput * device = new MacAudioInput( name, d->getDeviceID() );
            
            IOManager::instance().registerNode( device );
        }
        iter++;
    }
}

static void initAudioOutput()
{
    AudioHardware & hw = AudioHardware::instance();
    
    AudioHardware::List & hwList = hw.getList();
    
    AudioHardware::List::Iterator iter = hwList.begin();
    
    while( iter != hwList.end() ) {
    
        IODescription * d = (IODescription*) (*iter);

        if( d->getDirection() == IODescription::ioOut ){

            string name = d->getName();
            
            name += " output";

            printf( "initAudioOutput: adding Device(%s) id(%d)\n", name.c_str(), d->getDeviceID() );

            IOAudioOutput * device = new IOAudioOutput( name, d->getDeviceID() );
            
            IOManager::instance().registerNode( device );
        }
        
        
        iter++;
    }
}

extern "C" int initAudioPlugin( int argc, const char ** argv )
{
    puts("MacAudioPlugin.initPlugin");
    
    initAudioOutput();
    initAudioInput();
    
    return true;
}