//
//  Puissance3Dj.java
//  Puissance3Dj
//
//  Created by SuperCed on Wed Nov 26 2003.
//  Copyright (c) 2004 SuperCed. All rights reserved.
//

import java.util.Locale;
import java.util.ResourceBundle;

import java.awt.*;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.awt.event.*;

import javax.swing.*;
import javax.swing.event.*;

import java.io.*;
import java.lang.*;

import com.sun.j3d.utils.image.TextureLoader;




public class Puissance3Dj extends JFrame implements ChangeListener {

	private Font font = new Font("serif", Font.ITALIC+Font.BOLD, 36);
	protected ResourceBundle resbundle;
		
    //private JLabel emptyLabelList = new JLabel();
	
	private JLabel titleLabel;
	private JLabel levelLabel;
	private JLabel easyLabel;
	private JLabel hardLabel;
	
	private JButton onePlayerButton; 
	private JButton twoPlayersButton;
	
	private JSlider levelSlider;
	
	private JPanel mainPanel;
	
	private Color backgroundColor;
	
	private int difficultyLevel;
	
	private Puissance3DView mainPuissance3Dview;
	
	private Object me;
	
	public Puissance3Dj() {
		
		super("");
		
		me = this;
		
		resbundle = ResourceBundle.getBundle ("Puissance3Djstrings", Locale.getDefault());
		
		mainPanel = new JPanel();
		backgroundColor = new Color(0.85f, 0.85f, 0.85f);
		setContentPane(mainPanel);
		
		TextureLoader texLoader = new TextureLoader(getClass().getResource("images/title.tif"), null);
		ImageIcon imageTitle = new ImageIcon(texLoader.getImage().getImage()); 
		this.titleLabel = new JLabel(imageTitle); 
		
		this.onePlayerButton = new JButton(resbundle.getString("onePlayer"));
		onePlayerButton.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				System.gc();
				mainPuissance3Dview = new Puissance3DView();
				mainPuissance3Dview.setVisible(false);
				mainPuissance3Dview.setResBundle(resbundle);	   
				mainPuissance3Dview.setMainWindow((Puissance3Dj)me);
				mainPuissance3Dview.setPlayerNumber(1);
				mainPuissance3Dview.setLevel((int)(levelSlider.getValue()));
				mainPuissance3Dview.setVisible(true);
				((Puissance3Dj)me).setVisible(false);
				mainPuissance3Dview.initGame();
				}
			});
		
		this.twoPlayersButton = new JButton(resbundle.getString("twoPlayers")); 
		twoPlayersButton.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				System.gc();
				mainPuissance3Dview = new Puissance3DView();
				mainPuissance3Dview.setVisible(false);
				mainPuissance3Dview.setResBundle(resbundle);	   
				mainPuissance3Dview.setMainWindow((Puissance3Dj)me);
				mainPuissance3Dview.setPlayerNumber(2);
				mainPuissance3Dview.setLevel((int)(levelSlider.getValue()));
				mainPuissance3Dview.setVisible(true);
				((Puissance3Dj)me).setVisible(false);
				mainPuissance3Dview.initGame();
			}
		});
		
		levelSlider = new JSlider(0,5);
		levelSlider.setPaintTicks(true);
		levelSlider.setMinorTickSpacing(1);
		levelSlider.addChangeListener(this);
		
		
		levelLabel = new JLabel(resbundle.getString("difficulty"));
		
		easyLabel = new JLabel(resbundle.getString("easy"));
		
		hardLabel = new JLabel(resbundle.getString("hard"));
		
		setTitle(resbundle.getString("frameConstructor"));
		this.getContentPane().setLayout(null);
		
		setSize(300,200);
		Container conteneur = this.getContentPane(); 
		GridLayout disposition = new GridLayout(3,1,0,0);
		getContentPane().setLayout(disposition);
		JPanel topPane = new JPanel();
		JPanel centerPane = new JPanel();
		JPanel bottomPane = new JPanel();
		
		getContentPane().add(topPane);
		getContentPane().add(centerPane);
		getContentPane().add(bottomPane);
		
		BorderLayout disposition2 = new BorderLayout(0,10);
		topPane.setLayout(disposition2);
		
		BorderLayout disposition3 = new BorderLayout(0,0);
		centerPane.setLayout(disposition3);
		
		BorderLayout disposition4 = new BorderLayout(0,0);
		bottomPane.setLayout(disposition4);
		
		topPane.add(titleLabel, BorderLayout.NORTH);
		
		centerPane.add(levelLabel, BorderLayout.NORTH);
		centerPane.add(easyLabel, BorderLayout.WEST); 
		centerPane.add(levelSlider, BorderLayout.CENTER);
		centerPane.add(hardLabel, BorderLayout.EAST);
		centerPane.add(onePlayerButton, BorderLayout.SOUTH); 
		
		bottomPane.add(twoPlayersButton, BorderLayout.NORTH);
				
		this.pack();
		setVisible(true);
		setResizable(false);
		
		Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
		setLocation((screen.width - getSize().width)/2,(screen.height - getSize().height)/2);
	}
	
	public void setMainPuissance3DView (Puissance3DView window) {
		mainPuissance3Dview = window;
	}
	
	public Insets getInsets() {
         return new Insets(30,50,-60,30);
	}
	
	public void stateChanged(ChangeEvent e) {
		JSlider source = (JSlider)e.getSource();
		difficultyLevel = (int)source.getValue();
		source.setValue(difficultyLevel);
		source.repaint();
	}
        
	public void paint(Graphics g) {
		super.paint(g);
	}
	
	 public static void main(String args[]) {
		new Puissance3Dj();
	 }

}