//
//  Puissance3DView.java
//  Puissance3Dj
//
//  Created by SuperCed on Wed Nov 26 2003.
//  Copyright (c) 2004 SuperCed. All rights reserved.
//

import com.sun.j3d.utils.universe.SimpleUniverse;
import com.sun.j3d.utils.geometry.ColorCube;
import javax.media.j3d.*;
import javax.vecmath.*;
import java.awt.BorderLayout;
import java.awt.GraphicsConfiguration;
import com.sun.j3d.utils.image.TextureLoader;
import java.awt.image.BufferedImage;
import com.sun.j3d.utils.behaviors.mouse.*;
import java.util.*;

import java.io.*;

import java.awt.* ;
import java.awt.event.* ;

import javax.swing.*;
import javax.swing.event.*;


    public class Puissance3DView extends JFrame implements /*KeyListener,*/ Runnable {
        private Transform3D rotate1 = new Transform3D();
        private Transform3D rotate2 = new Transform3D();
		private Transform3D rotate3 = new Transform3D();
		private Transform3D rotate4 = new Transform3D();
        private Transform3D rotate5 = new Transform3D();
		private Transform3D rotate6 = new Transform3D();
		private Transform3D translate1 = new Transform3D();
		private Transform3D translate2 = new Transform3D();
		private Transform3D translate3 = new Transform3D();
        private Object3DX table;
		private Object3DX baton;
		private Object3DX greenPerl;
		private Object3DX pinkPerl;
		private TriangleArray triangle;
		private Vertex v;
		private Canvas3D canvas3D;
		private boolean transparencyFlag;
		private Texture2D texture;
		private float transparencyFactor;
		private Shape3D pinkPerls[] = new Shape3D[64];
		private Shape3D greenPerls[] = new Shape3D[64];
		private Hashtable objectsDictionary = new Hashtable();
		private Hashtable texturesDictionary = new Hashtable();
		
		private CedJButton buttonsList[];
		private JButton seeLastPerl;
		private JLabel infoLabel;
		private JProgressBar gameProgressBar;
		private JButton stopButton;
		private JPanel leftPanel;
		private JPanel topLeftPanel;
		private JPanel bottomLeftPanel;
		
		private ImageIcon   roseRollover;
		private ImageIcon   roseDown;
		private ImageIcon   greenRollover;
		private ImageIcon   greenDown;
		
		private ResourceBundle resbundle;
		private int playerNumber;
		private Puissance3Dj mainWindow;
		private int difficultyLevel;
		private int player;
		private int nbPerlPut;
		private int line;
		
		private char perlArrayRepresentation[];
		private char perlArrayRepresentationCache[];
		
		private Object me;
		private Thread computerThinks;
		private int progressBarValue;
		private int lastPerl;
	

       public Puissance3DView() {
         
		 // super
		 super("Puissance3DView");
		 
		 me = this;
		 lastPerl = -1;
		 
		 perlArrayRepresentation = new char[64];
		 perlArrayRepresentationCache = new char[64];
		 nbPerlPut = 0;
		 canvas3D = createCanvas3D();
		 
		 // 3D world
		 table = new Object3DX("objects/plaque.x");
		 baton = new Object3DX("objects/batonnet.x");
		 greenPerl = new Object3DX("objects/perleverte.x");
		 pinkPerl = new Object3DX("objects/perlerose.x");
		 //System.out.println ("Objets loaded");
		 		 
         BranchGroup scene = createSceneGraph();
		 		 
		 SimpleUniverse universe = new SimpleUniverse (canvas3D);
		 universe.addBranchGraph (scene);
		 universe.getViewingPlatform().setNominalViewingTransform ();
		
		 
		 /*----- Position  de l'observateur -----*/
		 Transform3D t3d_oeil = new Transform3D();
		 t3d_oeil.set(new Vector3f(0.0f,0.0f,0.9f));
		 rotate5.rotX(-Math.PI / 4.0d);
		 rotate5.mul(t3d_oeil);
		 universe.getViewingPlatform().getViewPlatformTransform().setTransform(rotate5);
		 
		 
		 canvas3D.getView().setTransparencySortingPolicy(View.TRANSPARENCY_SORT_GEOMETRY);
		 canvas3D.getView().setSceneAntialiasingEnable(false);
		 canvas3D.getView().setFrontClipDistance(0.01);
		 //canvas3D.getView().setCompatibilityModeEnable(true);
		 
		 // events
		 //canvas3D.addKeyListener(this);
		 
		 this.setSize(600,400);
		 gameProgressBar.setValue(16);
		 setEnableInterface(true);
		 player = 0;
		 Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
		 setLocation((screen.width - getSize().width)/2,(screen.height - getSize().height)/2);
		 
       }
	   
	   public void setResBundle(ResourceBundle res) {
			resbundle = res;
	   }
	   
	   public void setPlayerNumber (int n) {
			playerNumber = n;
	   }
	   
	   public void initGame() {
			TransparencyAttributes temp1, temp2;
			nbPerlPut=0;
			for (int i=0;i<64;i++) {
				perlArrayRepresentation[i] = 0;
				perlArrayRepresentationCache[i] = 0;
				temp1 = pinkPerls[i].getAppearance().getTransparencyAttributes();
				temp1.setTransparencyMode(TransparencyAttributes.NICEST);
				temp1.setTransparency(1.0f);
				temp2 = greenPerls[i].getAppearance().getTransparencyAttributes();
				temp2.setTransparencyMode(TransparencyAttributes.NICEST);
				temp2.setTransparency(1.0f);
			}
			setIconsColor(false);
			seeLastPerl.setText(resbundle.getString("seeLastPerl"));
			infoLabel.setText(resbundle.getString("yourTurn"));
			stopButton.setText(resbundle.getString("stopButton"));
			setTitle(resbundle.getString("frameConstructorView"));
			player = 1;
	   }
	   
	   public void refreshPerls() {
			/************* First implementation-slow ***************/
			/*TransparencyAttributes temp1, temp2;
			for (int i=0;i<64;i++) {
				switch (perlArrayRepresentation[i]) {
					case 0 :
						temp1 = pinkPerls[i].getAppearance().getTransparencyAttributes();
						temp1.setTransparencyMode(TransparencyAttributes.NICEST);
						temp1.setTransparency(1.0f);
						temp2 = greenPerls[i].getAppearance().getTransparencyAttributes();
						temp2.setTransparencyMode(TransparencyAttributes.NICEST);
						temp2.setTransparency(1.0f);
						//System.out.println("0");
						break;
					case 1 :
						pinkPerls[i].getAppearance().getTransparencyAttributes().setTransparencyMode(TransparencyAttributes.NONE);
						temp2 = greenPerls[i].getAppearance().getTransparencyAttributes();
						temp2.setTransparencyMode(TransparencyAttributes.NICEST);
						temp2.setTransparency(1.0f);
						System.out.println("1");
						break;
					case 2 :
						greenPerls[i].getAppearance().getTransparencyAttributes().setTransparencyMode(TransparencyAttributes.NONE);
						temp2 = pinkPerls[i].getAppearance().getTransparencyAttributes();
						temp2.setTransparencyMode(TransparencyAttributes.NICEST);
						temp2.setTransparency(1.0f);
						//System.out.println("2");
						break;
					case 3 :
						temp1 = pinkPerls[i].getAppearance().getTransparencyAttributes();
						temp1.setTransparencyMode(TransparencyAttributes.NICEST);
						temp1.setTransparency(0.5f);
						temp2 = greenPerls[i].getAppearance().getTransparencyAttributes();
						temp2.setTransparencyMode(TransparencyAttributes.NICEST);
						temp2.setTransparency(1.0f);
						//System.out.println("3");
						break;
					case 4 :
						temp1 = pinkPerls[i].getAppearance().getTransparencyAttributes();
						temp1.setTransparencyMode(TransparencyAttributes.NICEST);
						temp1.setTransparency(1.0f);
						temp2 = greenPerls[i].getAppearance().getTransparencyAttributes();
						temp2.setTransparencyMode(TransparencyAttributes.NICEST);
						temp2.setTransparency(0.5f);
						//System.out.println("4");
						break;
					
				}
			}
			/************* Second implementation with cache-faster ***************/
			int i=0;
			TransparencyAttributes temp1, temp2;
			boolean test;
			test = false;
			if (i<64) {
				if (perlArrayRepresentation[i]==perlArrayRepresentationCache[i]) {
					test = true;
				}
			}
			while (test) {
				i++;
				test = false;
				if (i<64) {
					if (perlArrayRepresentation[i]==perlArrayRepresentationCache[i]) {
						test = true;
					}
				}
			}
			if (i>63) {
				return;
			}
			perlArrayRepresentationCache[i] = perlArrayRepresentation[i];
				switch (perlArrayRepresentation[i]) {
					case 0 :
						temp1 = pinkPerls[i].getAppearance().getTransparencyAttributes();
						temp1.setTransparencyMode(TransparencyAttributes.NICEST);
						temp1.setTransparency(1.0f);
						temp2 = greenPerls[i].getAppearance().getTransparencyAttributes();
						temp2.setTransparencyMode(TransparencyAttributes.NICEST);
						temp2.setTransparency(1.0f);
						break;
					case 1 :
						pinkPerls[i].getAppearance().getTransparencyAttributes().setTransparencyMode(TransparencyAttributes.NONE);
						temp2 = greenPerls[i].getAppearance().getTransparencyAttributes();
						temp2.setTransparencyMode(TransparencyAttributes.NICEST);
						temp2.setTransparency(1.0f);
						break;
					case 2 :
						greenPerls[i].getAppearance().getTransparencyAttributes().setTransparencyMode(TransparencyAttributes.NONE);
						temp2 = pinkPerls[i].getAppearance().getTransparencyAttributes();
						temp2.setTransparencyMode(TransparencyAttributes.NICEST);
						temp2.setTransparency(1.0f);
						break;
					case 3 :
						temp1 = pinkPerls[i].getAppearance().getTransparencyAttributes();
						temp1.setTransparencyMode(TransparencyAttributes.NICEST);
						temp1.setTransparency(0.3f);
						temp2 = greenPerls[i].getAppearance().getTransparencyAttributes();
						temp2.setTransparencyMode(TransparencyAttributes.NICEST);
						temp2.setTransparency(1.0f);
						break;
					case 4 :
						temp1 = pinkPerls[i].getAppearance().getTransparencyAttributes();
						temp1.setTransparencyMode(TransparencyAttributes.NICEST);
						temp1.setTransparency(1.0f);
						temp2 = greenPerls[i].getAppearance().getTransparencyAttributes();
						temp2.setTransparencyMode(TransparencyAttributes.NICEST);
						temp2.setTransparency(0.3f);
						break;
					
				}
	   }
	   
	   
       /*public void keyPressed(KeyEvent evt) {
			if (evt.getKeyCode() == 38) {
				transparencyFactor += 0.1f;
			} else if (evt.getKeyCode() == 40) {
				transparencyFactor -= 0.1f;
			}
			for (int i = 0;i<32;i++) {
				if (transparencyFactor <0.1f) {
					pinkPerls[i].getAppearance().getTransparencyAttributes().setTransparencyMode(TransparencyAttributes.NONE);
				} else {
					TransparencyAttributes temp = pinkPerls[i].getAppearance().getTransparencyAttributes();
					temp.setTransparencyMode(TransparencyAttributes.NICEST);
					temp.setTransparency(transparencyFactor);
				}
				
			}
		}

        public void keyTyped(KeyEvent evt) { }

        public void keyReleased(KeyEvent evt) { }*/
		
		public Insets insets() {
			return new Insets(30,10,10,10);
		}
		
		public void setMainWindow(Puissance3Dj me) {
			mainWindow = me;
		}
		
		public void setLevel(int l) {
			difficultyLevel = l;
		}

       private Canvas3D createCanvas3D() {
         setSize(300, 300);
		 BorderLayout disposition1 = new BorderLayout(20,20);
         getContentPane().setLayout(disposition1);
		 
         GraphicsConfiguration config = SimpleUniverse.getPreferredConfiguration();
         Canvas3D canvas3D = new Canvas3D(config);
         setSize(600, 300);
         getContentPane().add(canvas3D, BorderLayout.CENTER);
		 
		 leftPanel = new JPanel();
         BorderLayout disposition2 = new BorderLayout();
		 leftPanel.setLayout(disposition2);
		 
		 topLeftPanel = new JPanel();
		 		 
		 getContentPane().add(leftPanel, BorderLayout.EAST);
		 
		 bottomLeftPanel = new JPanel();
		 
		 leftPanel.add(topLeftPanel,BorderLayout.NORTH);
		 leftPanel.add(bottomLeftPanel,BorderLayout.SOUTH);
		 
		 TextureLoader texLoader1 = new TextureLoader(getClass().getResource("images/baton.tif"), null);
		 ImageIcon baton = new ImageIcon(texLoader1.getImage().getImage());
		 
		 TextureLoader texLoader2 = new TextureLoader(getClass().getResource("images/batonroseover.tif"), null);
		 roseRollover= new ImageIcon(texLoader2.getImage().getImage());
		 
		 TextureLoader texLoader3 = new TextureLoader(getClass().getResource("images/batonrosedown.tif"), null);
		 roseDown= new ImageIcon(texLoader3.getImage().getImage());
		 
		 TextureLoader texLoader5 = new TextureLoader(getClass().getResource("images/batonverteover.tif"), null);
		 greenRollover= new ImageIcon(texLoader5.getImage().getImage());
		 
		 TextureLoader texLoader6 = new TextureLoader(getClass().getResource("images/batonvertedown.tif"), null);
		 greenDown= new ImageIcon(texLoader6.getImage().getImage());


		 GridLayout disposition3 = new GridLayout(4,4);
         topLeftPanel.setLayout(disposition3);
		 buttonsList = new CedJButton[16];
		 for (int i=0;i<16;i++) {
			buttonsList[i] = new CedJButton(baton, this, i);
			buttonsList[i].setRolloverEnabled(true);
			buttonsList[i].setBorder(BorderFactory.createEmptyBorder());
			topLeftPanel.add(buttonsList[i]);
		 }
		 
		 setIconsColor(false);
		 
		 GridLayout disposition4 = new GridLayout(4,1);
         bottomLeftPanel.setLayout(disposition4);
		 seeLastPerl = new JButton("See Last Perl");
		 bottomLeftPanel.add(seeLastPerl);
		 seeLastPerl.addMouseListener(new MouseListener() {
			public void mousePressed(MouseEvent e) {
				if (lastPerl!=-1) {
					perlArrayRepresentation[lastPerl] +=2;
					refreshPerls();
				}
			}
			public void mouseClicked(java.awt.event.MouseEvent e) {}
			public void mouseReleased(java.awt.event.MouseEvent e) {
				if (lastPerl!=-1) {
					perlArrayRepresentation[lastPerl] -=2;
					refreshPerls();
				}
			}
			public void mouseEntered(java.awt.event.MouseEvent e) {}
			public void mouseExited(java.awt.event.MouseEvent e) {}
			});
		 infoLabel = new JLabel("Your turn");
		 bottomLeftPanel.add(infoLabel);
		 gameProgressBar = new JProgressBar(0,15);
		 bottomLeftPanel.add(gameProgressBar);
		 stopButton = new JButton("Stop Button");
		 stopButton.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				mainWindow.setVisible(true);
				((Puissance3DView)me).setVisible(false);
				}
			});
		 
		 bottomLeftPanel.add(stopButton);
		 		 
		 return canvas3D;
       }
	   
	   public void processMouseEnter(int i) {
			int j = 0;
			int k;
			boolean test;
			test = false;
			if (j<64) {
				if ((k=perlArrayRepresentation[i+j])==1 || k==2) {
					test = true;
				}
			}
			while (test) {
				j+=16;
				test = false;
				if (j<64) {
					if ((k=perlArrayRepresentation[i+j])==1 || k==2) {
						test = true;
					}
				}
			}
			if (j>63) {
				return;
			}
			switch (player) {
				case 1:
					perlArrayRepresentation[i+j] =3;
					break;
				case 2:
					perlArrayRepresentation[i+j] =4;
					break;
			}
			refreshPerls();
	   }
	   public void processMouseExit(int i) {
			int j = 0;
			boolean test;
			test = false;
			if (j<64) {
				if (perlArrayRepresentation[i+j]==1 || perlArrayRepresentation[i+j]==2) {
					test = true;
				}
			}
			while (test) {
				j+=16;
				test = false;
				if (j<64) {
					if (perlArrayRepresentation[i+j]==1 || perlArrayRepresentation[i+j]==2) {
						test = true;
					}
				}
			}
			if (j>63) {
				return;
			}
			if (perlArrayRepresentation[i+j]>2) {
				perlArrayRepresentation[i+j] = 0;
			}
			refreshPerls();
	   }
	   
	   public void processMouseClick(int i) {
			int j = 0;
			boolean test;
			test = false;
			if (j<64) {
				if (perlArrayRepresentation[i+j]==1 || perlArrayRepresentation[i+j]==2) {
					test = true;
				}
			}
			while (test) {
				j+=16;
				test = false;
				if (j<64) {
					if (perlArrayRepresentation[i+j]==1 || perlArrayRepresentation[i+j]==2) {
						test = true;
					}
				}
			}
			if (j>63) {
				return;
			}
			nbPerlPut++;
			lastPerl = -1;
			switch (player) {
				case 1 :
					perlArrayRepresentation[i+j] =1;
					lastPerl = i+j;
					refreshPerls();
					if (checkWinner()==1) {
						illuminateLine(line);
						setEnableInterface(false);
						if (playerNumber==1) {
							infoLabel.setText(resbundle.getString("youWin"));
							CedJDialog d = new CedJDialog(this, resbundle.getString("youWin"), true);
							d.setVisible(true);
						} else {
							infoLabel.setText(resbundle.getString("player1Wins"));
							CedJDialog d = new CedJDialog(this, resbundle.getString("player1Wins"), true);
							d.setVisible(true);
						}
						return;
					}
					if (nbPerlPut == 64) {
						setEnableInterface(false);
						infoLabel.setText(resbundle.getString("equality"));
						CedJDialog d = new CedJDialog(this, resbundle.getString("equality"), true);
						d.setVisible(true);
						d.pack();
						return;
					}
					if (playerNumber==1) {
						infoLabel.setText(resbundle.getString("computerIsThinking"));
						setEnableInterface(false);
						computerThinks = new Thread(this);
						computerThinks.start();
						
					} else {
						infoLabel.setText(resbundle.getString("player2Turn"));
						setIconsColor(true);
						player = 2;
					}
					break;
				case 2 :
					perlArrayRepresentation[i+j] =2;
					lastPerl = i+j;
					refreshPerls();
					if (checkWinner()==2) {
						illuminateLine(line);
						setEnableInterface(false);
						infoLabel.setText(resbundle.getString("player2Wins"));
						CedJDialog d = new CedJDialog(this, resbundle.getString("player2Wins"), true);
						d.setVisible(true);
						d.pack();
						return;
					}
					if (nbPerlPut == 64) {
						setEnableInterface(false);
						infoLabel.setText(resbundle.getString("equality"));
						CedJDialog d = new CedJDialog(this, resbundle.getString("equality"), true);
						d.setVisible(true);
						d.pack();
						return;
					}
					player = 1;
					infoLabel.setText(resbundle.getString("player1Turn"));
					setIconsColor(false);
					break;
			}
	   }
	   
	   
	   public void run() {
			computerThinks();
	   }
	   
	   public void computerThinks() {
			int toPlay;
			int maxScore;
			int i, temp, j;
			int level;
			boolean test;
			char tab2[] = new char[64];
			line = -1;
			level = difficultyLevel;
			if (level>(64 - nbPerlPut)) {
				level = 64 - nbPerlPut;
			}
			maxScore = -268435456;
			toPlay = 0;
			progressBarValue = 0;
			Runnable setComputerProgressBarValue = new Runnable() {
				public void run() {
					gameProgressBar.setValue(progressBarValue);
				}
			};
			try {
				SwingUtilities.invokeLater(setComputerProgressBarValue);
			} catch (Exception e) {
				System.out.println (e);
			}
			for (i=0;i<16;i++) {
				progressBarValue = i;
				try {
					SwingUtilities.invokeAndWait(setComputerProgressBarValue);
				} catch (Exception e) {
					System.out.println (e);
				}
				
				tab2 = (char[])perlArrayRepresentation.clone();
				j = 0;
				for (int k=0;k<64;k++) {
					if (tab2[k]>2) {
						tab2[k] = 0;
					}
				}
				test = false;
				if (j<4) {
					if (tab2[i+j*16]!=0) {
						test = true;
					}
				}		
				while (test){
					j++;
					test = false;
					if (j<4) {
						if (tab2[i+j*16]!=0) {
							test = true;
						}
					}
				}
				if (j<4) {
					int debug2 = i+j*16;
					tab2[debug2] = 2;
					temp = minMaxAlphaBeta(level, tab2, maxScore, 16777216);
					if (temp>=maxScore) {
						maxScore = temp;
						toPlay = i;
					}
				}
			}
			j=0;
			test = false;
			if (j<64) {
				if (perlArrayRepresentation[toPlay+j]==1 || perlArrayRepresentation[toPlay+j]==2) {
					test = true;
				}
			}
			while (test) {
				j+=16;
				test = false;
				if (j<64) {
					if (perlArrayRepresentation[toPlay+j]==1 || perlArrayRepresentation[toPlay+j]==2) {
						test = true;
					}
				}
			}
			if (j>63) {
				// pas possible de jouer
				return;
			}
			perlArrayRepresentation[toPlay+j] =2;
			lastPerl = toPlay+j;
			gameProgressBar.setValue(16);
			repaint();
			refreshPerls();
			nbPerlPut++;
			if (checkWinner()==2) {
				illuminateLine(line);
				setEnableInterface(false);
				infoLabel.setText(resbundle.getString("computerWins"));
				CedJDialog d = new CedJDialog(this, resbundle.getString("computerWins"), true);
				
				d.setVisible(true);
				d.pack();
				return;
			}
			if (nbPerlPut == 64) {
				setEnableInterface(false);
				infoLabel.setText(resbundle.getString("equality"));
				CedJDialog d = new CedJDialog(this, resbundle.getString("equality"), true);
				d.setVisible(true);
				d.pack();
				return;
			}
			setEnableInterface(true);
			infoLabel.setText(resbundle.getString("yourTurn"));
			
		}
	   
	   private int checkWinner() {
			char tab2[];
			tab2 = (char[])perlArrayRepresentation.clone();
			for (int k=0;k<64;k++) {
				if (tab2[k]>2) {
					tab2[k] = 0;
				}
			}
			int temp = evaluationFunction(tab2);
			switch (temp) {
				case 16777216:
					return 2;
					//break;
				case -268435456:
					return 1;
					//break;
			 }
			return 0;
	   }
	   
	   private void setIconsColor(boolean b) {
		if (b) {
			for (int i=0;i<16;i++) {
				buttonsList[i].setPressedIcon(roseDown);
				buttonsList[i].setRolloverIcon(roseRollover);
			}
		} else {
			for (int i=0;i<16;i++) {
				buttonsList[i].setPressedIcon(greenDown);
				buttonsList[i].setRolloverIcon(greenRollover);
			}
		}
	   }
	   
	   private void setEnableInterface(boolean b) {
		for (int i=0;i<16;i++) {
			buttonsList[i].setEnabled(b);
			buttonsList[i].setButtonEnabled(b);
		}
		seeLastPerl.setEnabled(b);
	   }
	   
	   private GridBagConstraints createGridBagConstraints (int gridx, int gridy, int gridwidth, int gridheight, int weightx, int weighty, int ipadx, int ipady, int fill, int anchor) {
			GridBagConstraints constraints = new GridBagConstraints();
			constraints.gridx = gridx;
			constraints.gridy = gridy;
			constraints.gridwidth = gridwidth;
			constraints.gridheight = gridheight;
			constraints.weightx = weightx;
			constraints.weighty = weighty;
			constraints.ipadx = ipadx;
			constraints.ipady = ipady;
			constraints.fill = fill;
			constraints.anchor = anchor;
			return constraints;
	   }
	   

       private BranchGroup createSceneGraph() {
			BranchGroup objRoot = new BranchGroup();
			
			/***************************/
			// Groupe de transformation sur lequel agisse les comportements
			TransformGroup mouseTransform = new TransformGroup ();
			mouseTransform.setCapability (TransformGroup.ALLOW_TRANSFORM_WRITE);
			mouseTransform.setCapability (TransformGroup.ALLOW_TRANSFORM_READ);
			
			BoundingSphere schedulingBounds = new BoundingSphere (new Point3d (), 10.0);
			
			// Cration des trois comportements ragissant aux mouvements de la souris
			MouseBehavior rotate = new MouseRotate (mouseTransform);
			rotate.setSchedulingBounds (schedulingBounds);

			MouseBehavior translate = new MouseTranslate (mouseTransform);
			translate.setSchedulingBounds (schedulingBounds);

			MouseBehavior zoom = new MouseZoom (mouseTransform);
			zoom.setSchedulingBounds (schedulingBounds);
			
			
			objRoot.addChild (rotate);
			objRoot.addChild (translate);
			objRoot.addChild (zoom);
			/******************************/
			
						
			transparencyFlag = false;
			objRoot.addChild (mouseTransform);
			mouseTransform.addChild (addObject(table));
			
			float x,y,z;
			x = 0.12f;
			y = 0.02f;
			z = 0.20f;
			Shape3D objBaton = addObject(baton);
			for (int i=0;i<16;i++) {
				if (i % 4 == 0) {
					x -= 0.32f; z -= 0.08f;
				}
				x += 0.08f;
				Vector3f vector = new Vector3f(x, y, z);
				translate1 = new Transform3D(); 
				translate1.setTranslation(vector);
				TransformGroup translator = new TransformGroup(translate1);
				translator.addChild (objBaton.cloneNode(true));
				mouseTransform.addChild (translator);
			}
			
			transparencyFlag = true;
			Shape3D objGreenPerl = addObject(greenPerl);
			Shape3D objPinkPerl = addObject(pinkPerl);
			y -=0.01f;z+=0.24f;
			for (int i=0;i<64;i++) {
				if (i % 16 == 0) {
					y += 0.02f; z -= 0.32f;
				}
				if (i % 4 == 0) {
					x -= 0.32f; z+=0.08f;
				}
				x += 0.08f;
				Vector3f vector = new Vector3f(x, y, z);
				translate1 = new Transform3D(); 
				translate1.setTranslation(vector);
				TransformGroup translator = new TransformGroup(translate1);
				transparencyFlag = true;
				pinkPerls[i] = addObject(greenPerl);
				greenPerls[i] = addObject(pinkPerl);
				translator.addChild (pinkPerls[i]);
				translator.addChild (greenPerls[i]);
				mouseTransform.addChild (translator);
				
			}
			//System.out.println ("view elements loaded");
			
		
		Color3f lightColor = new Color3f (1, 1, 0.9f); 
							 
		Light light1 = new DirectionalLight (lightColor,new Vector3f (-1, -1, 1)); 
       
		light1.setInfluencingBounds (new BoundingSphere (new Point3d (), 5.0));
		
		Light light2 = new DirectionalLight (lightColor,new Vector3f (0.0f, -1f, -1.0f)); 
       
		light2.setInfluencingBounds (new BoundingSphere (new Point3d (), 10.0));
		// Ajout de la lumire  l'arbre de la scne
		objRoot.addChild (light1);
		objRoot.addChild (light2);
			
		objRoot.compile();
		
         return objRoot;
       }
	   
	
	private Shape3D addObject(Object3DX obj) {
	Shape3D socle;
	socle=new Shape3D();
	
	if (objectsDictionary.containsKey(obj.name)) {
		Shape3D temp;
		
		temp = (Shape3D)objectsDictionary.get(obj.name);
		socle.setGeometry(temp.getGeometry());
		Appearance appear = temp.getAppearance();
		Appearance appear2 = new Appearance();
		socle.setCapability(Shape3D.ALLOW_APPEARANCE_READ);
		socle.setCapability(Shape3D.ALLOW_APPEARANCE_WRITE);
		socle.setAppearance(appear2);
		appear2.setMaterial(appear.getMaterial());
		appear2.setColoringAttributes(appear.getColoringAttributes());
		appear2.setLineAttributes(appear.getLineAttributes());
        appear2.setPolygonAttributes(appear.getPolygonAttributes());
		appear2.setCapability(Appearance.ALLOW_TRANSPARENCY_ATTRIBUTES_READ);
		appear2.setCapability(Appearance.ALLOW_TRANSPARENCY_ATTRIBUTES_WRITE);
		if (transparencyFlag) {
			TransparencyAttributes  transp = new TransparencyAttributes();
			transp.setTransparencyMode(TransparencyAttributes.NICEST);
			transparencyFactor = 0.5f;
			transp.setCapability(TransparencyAttributes.ALLOW_VALUE_READ);
			transp.setCapability(TransparencyAttributes.ALLOW_VALUE_WRITE);
			transp.setCapability(TransparencyAttributes.ALLOW_MODE_READ);
			transp.setCapability(TransparencyAttributes.ALLOW_MODE_WRITE);
			transp.setTransparency(transparencyFactor);
			appear2.setTransparencyAttributes(transp);
		}
		appear2.setTexture(appear.getTexture());
		appear2.setTextureAttributes(appear.getTextureAttributes());
		return socle;
	} else {
		triangle = new TriangleArray(obj.nbTriangles * 3,TriangleArray.COORDINATES|TriangleArray.NORMALS|TriangleArray.TEXTURE_COORDINATE_2);
		int i = 0;
		int j = 0;
		while (i<(obj.nbTriangles * 3)) {
			v = obj.vertexList[obj.triangleList[j].a];
			triangle.setCoordinate(i,new Point3f(v.x,v.y,v.z));
			triangle.setNormal(i, new Vector3f(v.nx,v.ny,v.nz));
			triangle.setTextureCoordinate(0, i, new TexCoord2f(v.u, v.v));
			i++;
			v = obj.vertexList[obj.triangleList[j].b]; 
			triangle.setCoordinate(i,new Point3f(v.x,v.y,v.z));
			triangle.setNormal(i, new Vector3f(v.nx,v.ny,v.nz));
			triangle.setTextureCoordinate(0, i, new TexCoord2f(v.u, v.v));
			i++;
			v = obj.vertexList[obj.triangleList[j].c]; 
			triangle.setCoordinate(i,new Point3f(v.x,v.y,v.z));
			triangle.setNormal(i, new Vector3f(v.nx,v.ny,v.nz));
			
			triangle.setTextureCoordinate(0, i, new TexCoord2f(v.u, v.v));
			i++;
			j++;
		} 
		socle.setGeometry(triangle);
		Appearance appear = new Appearance();
		appear.setMaterial (new Material ());
		
		CedMaterial mat = obj.materialList[obj.triangleList[j-1].material];
		
		if (texturesDictionary.contains(mat.textureFileName)) {
			texture = (Texture2D) texturesDictionary.get(mat.textureFileName);
		} else {
			TextureLoader texLoader = new TextureLoader(getClass().getResource("textures/"+ mat.textureFileName), null);
			texture = (Texture2D) texLoader.getTexture();
			texturesDictionary.put(mat.textureFileName, texture);
		}
		
		TextureAttributes texAttr = new TextureAttributes();
		texAttr.setTextureMode(TextureAttributes.MODULATE);
		texAttr.setTextureBlendColor(new Color4f(0.0f, 0.0f, 0.0f, 0.0f));
		texAttr.setPerspectiveCorrectionMode(TextureAttributes.NICEST);
		
		/*****************************/
		ColoringAttributes colAttrib = new ColoringAttributes();
        colAttrib.setCapability(ColoringAttributes.ALLOW_SHADE_MODEL_READ);
        colAttrib.setCapability(ColoringAttributes.ALLOW_SHADE_MODEL_WRITE);

        
		colAttrib.setShadeModel(ColoringAttributes.SHADE_GOURAUD);  
        appear.setColoringAttributes(colAttrib);


        // attributs relatifs aux lignes (inutiles pour une surface)
        // initialises quand meme pour la coherence de updateAppearance()
        LineAttributes lineAttrib = new LineAttributes(2F, LineAttributes.PATTERN_SOLID, true);
		lineAttrib.setLineAntialiasingEnable(false);
        lineAttrib.setCapability(LineAttributes.ALLOW_ANTIALIASING_READ);
        lineAttrib.setCapability(LineAttributes.ALLOW_ANTIALIASING_WRITE);
        appear.setLineAttributes(lineAttrib);
		
		// attributs des polygones : leurs deux faces devront etres affichables
        PolygonAttributes polyAttrib = new PolygonAttributes();
		polyAttrib.setCullFace(PolygonAttributes.CULL_NONE);
        appear.setPolygonAttributes(polyAttrib);
		
		if (transparencyFlag) {
			TransparencyAttributes  transp = new TransparencyAttributes();
			transp.setTransparencyMode(TransparencyAttributes.NICEST);
			transparencyFactor = 0.5f;
			transp.setCapability(TransparencyAttributes.ALLOW_VALUE_READ);
			transp.setCapability(TransparencyAttributes.ALLOW_VALUE_WRITE);
			transp.setCapability(TransparencyAttributes.ALLOW_MODE_READ);
			transp.setCapability(TransparencyAttributes.ALLOW_MODE_WRITE);
			transp.setTransparency(transparencyFactor);
			appear.setTransparencyAttributes(transp);
		}

		
		appear.setCapability(Appearance.ALLOW_COLORING_ATTRIBUTES_READ);
        //appear.setCapability(Appearance.ALLOW_COLORING_ATTRIBUTES_WRITE);
        appear.setCapability(Appearance.ALLOW_LINE_ATTRIBUTES_READ);
        //appear.setCapability(Appearance.ALLOW_LINE_ATTRIBUTES_WRITE);
        appear.setCapability(Appearance.ALLOW_MATERIAL_READ);
        //appear.setCapability(Appearance.ALLOW_MATERIAL_WRITE);
		appear.setCapability(Appearance.ALLOW_TRANSPARENCY_ATTRIBUTES_READ);
		appear.setCapability(Appearance.ALLOW_TRANSPARENCY_ATTRIBUTES_WRITE);
		
		/*****************************/
		
		appear.setTexture(texture);
		appear.setTextureAttributes(texAttr);
		
		socle.setAppearance(appear);
		socle.setCapability(Shape3D.ALLOW_APPEARANCE_READ);
		socle.setCapability(Shape3D.ALLOW_APPEARANCE_WRITE);
		
		objectsDictionary.put(obj.name, socle);
		
		return socle;
	   }
	}
	
	/*********************************************************/
	/* IA Parts */
	/*********************************************************/
	
private int evaluationFunction(char perlTab[]) {
    int total = 0;
    int pinkNumber, pinkNumber2, pinkNumber3, pinkNumber4;
    int greenNumber, greenNumber2, greenNumber3, greenNumber4;
    line = -1;
    int i, j, k, temp, temp2, temp3, temp4;
    
    // strait lines
    for (i=0;i<4;i++) {
        for (j=0;j<4;j++) {
            pinkNumber = 0;
            greenNumber = 0;
            pinkNumber2 = 0;
            greenNumber2 = 0;
            pinkNumber3 = 0;
            greenNumber3 = 0;
            for (k=0;k<4;k++) {
				
                temp = perlTab[i*16 + j*4 + k];
                temp2 = perlTab[i*16 + j + k*4];
                temp3 = perlTab[i + j*4 + k*16];
				
                if (temp!=0) {
                    if (temp == 1) {
                        pinkNumber++;
                    } else {
                        greenNumber++;
                    }
                }
                if (temp2!=0) {
                    if (temp2 == 1) {
                        pinkNumber2++;
                    } else {
                        greenNumber2++;
                    }
                }
                if (temp3!=0) {
                    if (temp3 == 1) {
                        pinkNumber3++;
                    } else {
                        greenNumber3++;
                    }
                }
            }
            if (pinkNumber == 4) {
                line = i*4+j;
                return -268435456;
            }
            if (greenNumber == 4) {
                line = i*4+j;
                return 16777216;
            }
            if (pinkNumber2 == 4) {
                line = i*4+j+16;
                return -268435456;
            }
            if (greenNumber2 == 4) {
                line = i*4+j+16;
                return 16777216;
            }
            if (pinkNumber3 == 4) {
                line = i*4+j+32;
                return -268435456;
            }
            if (greenNumber3 == 4) {
                line = i*4+j+32;
                return 16777216;
            }
            total += evaluateNumbers(pinkNumber, greenNumber);
            total += evaluateNumbers(pinkNumber2, greenNumber2);
            total += evaluateNumbers(pinkNumber3, greenNumber3);
        }
    }

    for (i=0;i<4;i++) {
        pinkNumber = 0;
        greenNumber = 0;
        pinkNumber2 = 0;
        greenNumber2 = 0;
        pinkNumber3 = 0;
        greenNumber3 = 0;
        pinkNumber4 = 0;
        greenNumber4 = 0;
        for (j=0;j<4;j++) {
			
            temp = perlTab[i*4 + j*16 + j];
            temp2 = perlTab[i*4 + (3-j)*16 + j];
            temp3 = perlTab[j*4 + j*16 + i];
            temp4 = perlTab[j*4 + (3-j)*16 + i];
			
            if (temp!=0) {
                if (temp == 1) {
                    pinkNumber++;
                } else {
                    greenNumber++;
                }
            }
            if (temp2!=0) {
                if (temp2 == 1) {
                    pinkNumber2++;
                } else {
                    greenNumber2++;
                }
            }
            if (temp3!=0) {
                if (temp3 == 1) {
                    pinkNumber3++;
                } else {
                    greenNumber3++;
                }
            }
            if (temp4!=0) {
                if (temp4 == 1) {
                    pinkNumber4++;
                } else {
                    greenNumber4++;
                }
            }
        }
        if (pinkNumber == 4) {
            line = i+48;
            return -268435456;
        }
        if (greenNumber == 4) {
            line = i+48;
            return 16777216;
        }
        if (pinkNumber2 == 4) {
            line = i+52;
            return -268435456;
        }
        if (greenNumber2 == 4) {
            line = i+52;
            return 16777216;
        }
        if (pinkNumber3 == 4) {
            line = i+56;
            return -268435456;
        }
        if (greenNumber3 == 4) {
            line = i+56;
            return 16777216;
        }
        if (pinkNumber4 == 4) {
            line = i+60;
            return -268435456;
        }
        if (greenNumber4 == 4) {
            line = i+60;
            return 16777216;
        }
        total += evaluateNumbers(pinkNumber, greenNumber);
        total += evaluateNumbers(pinkNumber2, greenNumber2);
        total += evaluateNumbers(pinkNumber3, greenNumber3);
        total += evaluateNumbers(pinkNumber4, greenNumber4);
    }
    for (i=0;i<4;i++) {
        pinkNumber = 0;
        greenNumber = 0;
        pinkNumber2 = 0;
        greenNumber2 = 0;
        for (j=0;j<4;j++) {
			
            temp = perlTab[i*16 + j*4 + j];
            temp2 = perlTab[i*16 + (3-j)*4 + j];
			
            if (temp!=0) {
                if (temp == 1) {
                    pinkNumber++;
                } else {
                    greenNumber++;
                }
            }
            if (temp2!=0) {
                if (temp2 == 1) {
                    pinkNumber2++;
                } else {
                    greenNumber2++;
                }
            }
        }
        if (pinkNumber == 4) {
            line = i+64;
            return -268435456;
        }
        if (greenNumber == 4) {
            line = i+64;
            return 16777216;
        }
        if (pinkNumber2 == 4) {
            line = i+68;
            return -268435456;
        }
        if (greenNumber2 == 4) {
            line = i+68;
            return 16777216;
        }
        total += evaluateNumbers(pinkNumber, greenNumber);
        total += evaluateNumbers(pinkNumber2, greenNumber2);
    }
    // real diagonals
    pinkNumber = 0;
    greenNumber = 0;
    pinkNumber2 = 0;
    greenNumber2 = 0;
    pinkNumber3 = 0;
    greenNumber3 = 0;
    pinkNumber4 = 0;
    greenNumber4 = 0;
    for (i=0;i<4;i++) {
				
        temp = perlTab[i*16 + i*4 + i];
        temp2 = perlTab[(3-i)*16 + i*4 + i];
        temp3 = perlTab[i*16 + i*4 + (3-i)];
        temp4 = perlTab[(3-i)*16 + i*4 + (3-i)];
		
	
		
        if (temp!=0) {
            if (temp == 1) {
                pinkNumber++;
            } else {
                greenNumber++;
            }
        }
        if (temp2!=0) {
            if (temp2 == 1) {
                pinkNumber2++;
            } else {
                greenNumber2++;
            }
        }
        if (temp3!=0) {
            if (temp3 == 1) {
                pinkNumber3++;
            } else {
                greenNumber3++;
            }
        }
        if (temp4!=0) {
            if (temp4 == 1) {
                pinkNumber4++;
            } else {
                greenNumber4++;
            }
        }
    }
    if (pinkNumber == 4) {
        line = 72;
        return -268435456;
    }
    if (greenNumber == 4) {
        line = 72;
        return -16777216;
    }
    if (pinkNumber2 == 4) {
        line = 73;
        return -268435456;
    }
    if (greenNumber2 == 4) {
        line = 73;
        return 16777216;
    }
    if (pinkNumber3 == 4) {
        line = 74;
        return -268435456;
    }
    if (greenNumber3 == 4) {
        line = 74;
        return 16777216;
    }
    if (pinkNumber4 == 4) {
        line = 75;
        return -268435456;
    }
    if (greenNumber4 == 4) {
        line = 75;
        return 16777216;
    }
    total += evaluateNumbers(pinkNumber, greenNumber);
    total += evaluateNumbers(pinkNumber2, greenNumber2);
    total += evaluateNumbers(pinkNumber3, greenNumber3);
    total += evaluateNumbers(pinkNumber4, greenNumber4);
    return total;
}

void illuminateLine(int i) {
    int j;
    if (i<16) {
        for (j=0;j<4;j++) {
            perlArrayRepresentation[(i/4)*16+(i%4)*4+j] +=2;
			refreshPerls();
        }
        return;
    }
    if (i<32) {
        i -= 16;
        for (j=0;j<4;j++) {
            perlArrayRepresentation[(i/4)*16+(i%4)+j*4] +=2;
			refreshPerls();
        }
        return;
    }
    if (i<48) {
        i -= 32;
        for (j=0;j<4;j++) {
            perlArrayRepresentation[(i/4)+(i%4)*4+j*16] +=2;
			refreshPerls();
        }
        return;
    }
    // diagonals
    if (i<52) {
        i -= 48;
        for (j=0;j<4;j++) {
            perlArrayRepresentation[i*4+j*16+j] +=2;
			refreshPerls();
        }
        return;
    }
    if (i<56) {
        i -= 52;
        for (j=0;j<4;j++) {
            perlArrayRepresentation[i*4+(3-j)*16+j] +=2;
			refreshPerls();
        }
        return;
    }
    if (i<60) {
        i -= 56;
        for (j=0;j<4;j++) {
            perlArrayRepresentation[i+j*16+j*4] +=2;
			refreshPerls();
        }
        return;
    }
    if (i<64) {
        i -= 60;
        for (j=0;j<4;j++) {
            perlArrayRepresentation[i+(3-j)*16+j*4] +=2;
			refreshPerls();
        }
        return;
    }
    // horizontal diagonals
    if (i<68) {
        i -= 64;
        for (j=0;j<4;j++) {
            perlArrayRepresentation[i*16+j*4+j] +=2;
			refreshPerls();
        }
        return;
    }
    if (i<72) {
        i -= 68;
        for (j=0;j<4;j++) {
            perlArrayRepresentation[i*16+(3-j)*4+j] +=2;
			refreshPerls();
        }
        return;
    }
    // real diagonals
    if (i<73) {
        for (j=0;j<4;j++) {
            perlArrayRepresentation[j*16+j*4+j] +=2;
			refreshPerls();
        }
        return;
    }
    if (i<74) {
        for (j=0;j<4;j++) {
            perlArrayRepresentation[(3-j)*16+j*4+j] +=2;
			refreshPerls();
        }
        return;
    }
    if (i<75) {
        for (j=0;j<4;j++) {
            perlArrayRepresentation[j*16+j*4+(3-j)] +=2;
			refreshPerls();
        }
        return;
    }
    if (i<76) {
        for (j=0;j<4;j++) {
            perlArrayRepresentation[(3-j)*16+j*4+(3-j)] +=2;
			refreshPerls();
        }
        return;
    }
    System.out.println("Line number unknown...");
}

private int evaluateNumbers(int pinkNumber, int greenNumber) {
    int score =0;
    switch (greenNumber) {
        case 0 :
            switch (pinkNumber) {
                case 0 :
                    score = 0;
                    break;
                case 1 :
                    score = -16;
                    break;
                case 2 : 
                    score = -4096;
                    break;
                case 3 :
                    score = -1048576;
                    break;
            }
            break;
        case 1 :
            switch (pinkNumber) {
                case 0 :
                    score = 1;
                    break;
                default :
                    score = 0;
                    break;
            }
            break;
        case 2 :
            switch (pinkNumber) {
                case 0 :
                    score = 256;
                    break;
                default :
                    score = 0;
                    break;
            }
            break;
        case 3 :
            switch (pinkNumber) {
                case 0 :
                    score = 65536;
                    break;
                default :
                    score = 0;
                    break;
            }
            break;
    }
    return score;
}

// alpha beta algorithm implementation
private int maxMinAlphaBeta(int level, char tab[], int alpha, int beta) {
    int temp;
	boolean test;
    if (level == 0) {
        return evaluationFunction(tab);
    }
    if (evaluationFunction(tab) == -268435456) {
        return -268435456;
    }
    int maxScore = -268435456;
    int i, j;
    char tab2[] = new char[64];
    for (i=0;i<16;i++) {
		tab2 = (char[])tab.clone();
        j = 0;
		int debug = i+j*16;
		test = false;
		if (j<4) {
			if (tab2[i+j*16]!=0) {
				test = true;
			}
		}
        while (test){
			j++;
			test = false;
			if (j<4) {
				if (tab2[i+j*16]!=0) {
					test = true;
				}
			}
        }
        if (j<4) {
            tab2[i+j*16] = 2;
            temp = minMaxAlphaBeta(level-1, tab2, maxScore, beta);
            if (temp>beta) {
                return temp;
            }
            if (temp>maxScore) {
                maxScore = temp;
            }
        }
    }
    return maxScore;
}

private int minMaxAlphaBeta(int level, char tab[], int alpha, int beta) {
    int temp;
	boolean test;
    if (level == 0) {
        return evaluationFunction(tab);
    }
    if (evaluationFunction(tab) == 16777216) {
        return 16777216;
    }
    int minScore = 16777216;
    int i, j;
    char tab2[] = new char[64];
    for (i=0;i<16;i++) {
		tab2 = (char[])tab.clone();
        j = 0;
		test = false;
		if (j<4) {
			if (tab2[i+j*16]!=0) {
				test = true;
			}
		}
        while (test){
            j++;
			test = false;
			if (j<4) {
				if (tab2[i+j*16]!=0) {
					test = true;
				}
			}
        }
        if (j<4) {
            tab2[i+j*16] = 1;
            temp = maxMinAlphaBeta(level-1, tab2, alpha, minScore);
            if (temp<alpha) {
                return temp;
            }
            if (temp<minScore) {
                minScore = temp;
            }
        }
    }
    return minScore;
}


}

