//
//  Object3DX.java
//  Puissance3Dj
//
//  Created by SuperCed on Wed Nov 26 2003.
//  Copyright (c) 2004 SuperCed. All rights reserved.
//

import java.io.*;
import java.util.*;

public class Object3DX {
    public Vertex vertexList[];
    public CedMaterial materialList[];
    public Triangle triangleList[];
    public int nbVertices;
	public int nbTriangles;
	public int nbMaterials;
	public String name;
    
    public Object3DX() {
    }
    public Object3DX(String path) {
        readObject(path);
    }
    public void readObject(String path) {
        try {
            int i;
			name = path;
			BufferedReader in = new BufferedReader(new InputStreamReader(getClass().getResourceAsStream(path)));
            LineNumberReader stream3 = new LineNumberReader(in);
            String line;
            line = stream3.readLine();
            while (line.lastIndexOf("Mesh") == -1) {
                line = stream3.readLine();
            }
            line = stream3.readLine();
            StringTokenizer st = new StringTokenizer(line, ";");
            String temp = new String(st.nextToken());
            nbVertices = Integer.parseInt(temp.trim());
            vertexList = new Vertex[nbVertices];
            for (i=0;i<nbVertices;i++) {
                line = stream3.readLine();
                st = new StringTokenizer(line, ";");
                temp = st.nextToken();
                vertexList[i] = new Vertex();
                vertexList[i].x = Float.valueOf(temp.trim()).floatValue();
                temp = st.nextToken();
                vertexList[i].y = Float.valueOf(temp.trim()).floatValue();
                temp = st.nextToken();
                vertexList[i].z = Float.valueOf(temp.trim()).floatValue();
            }
			line = stream3.readLine();
			st = new StringTokenizer(line, ";");
            temp = new String(st.nextToken());
            nbTriangles = Integer.parseInt(temp.trim());
			triangleList = new Triangle[nbTriangles];
			for (i=0;i<nbTriangles;i++) {
                line = stream3.readLine();
                st = new StringTokenizer(line, ";");
                temp = st.nextToken();
				temp = st.nextToken();
				temp += ",";
				st = new StringTokenizer(temp, ",");
				temp = st.nextToken();
                triangleList[i] = new Triangle();
                triangleList[i].a = Integer.parseInt(temp.trim());
                temp = st.nextToken();
                triangleList[i].b = Integer.parseInt(temp.trim());
                temp = st.nextToken();
                triangleList[i].c = Integer.parseInt(temp.trim());
				triangleList[i].material = -1;
            }
			while (line.lastIndexOf("MeshNormals") == -1) {
                line = stream3.readLine();
            }
			line = stream3.readLine();
            st = new StringTokenizer(line, ";");
            temp = new String(st.nextToken());
            for (i=0;i<nbVertices;i++) {
                line = stream3.readLine();
                st = new StringTokenizer(line, ";");
                temp = st.nextToken();
                vertexList[i].nx = Float.valueOf(temp.trim()).floatValue();
                temp = st.nextToken();
                vertexList[i].ny = Float.valueOf(temp.trim()).floatValue();
                temp = st.nextToken();
                vertexList[i].nz = Float.valueOf(temp.trim()).floatValue();
            }
			while (line.lastIndexOf("MeshTextureCoords") == -1) {
                line = stream3.readLine();
            }
			line = stream3.readLine();
            st = new StringTokenizer(line, ";");
            temp = new String(st.nextToken());
            for (i=0;i<nbVertices;i++) {
                line = stream3.readLine();
                st = new StringTokenizer(line, ";");
                temp = st.nextToken();
                vertexList[i].u = Float.valueOf(temp.trim()).floatValue();
                temp = st.nextToken();
                vertexList[i].v = Float.valueOf(temp.trim()).floatValue();
            }
			
			while (line.lastIndexOf("MeshMaterialList") == -1) {
                line = stream3.readLine();
            }
            line = stream3.readLine();
			st = new StringTokenizer(line, ";");
            temp = new String(st.nextToken());
            nbMaterials = Integer.parseInt(temp.trim());
            materialList = new CedMaterial[nbMaterials];
			line = stream3.readLine();
			st = new StringTokenizer(line, ";");
			temp = new String(st.nextToken());
			for (i=0;i<nbTriangles-1;i++) {
                line = stream3.readLine();
                st = new StringTokenizer(line, ",");
				temp = st.nextToken();
                triangleList[i].material = Integer.parseInt(temp.trim());
            }
			i = nbTriangles - 1;
			line = stream3.readLine();
			st = new StringTokenizer(line, ";");
			temp = st.nextToken();
			triangleList[i].material = Integer.parseInt(temp.trim());
			for (i=0;i<nbMaterials;i++) {
				while (line.lastIndexOf("Material") == -1) {
					line = stream3.readLine();
				}
				materialList[i] = new CedMaterial();
				line = stream3.readLine();
                st = new StringTokenizer(line, ";");
				temp = st.nextToken();
                materialList[i].diffusionR = Float.valueOf(temp.trim()).floatValue();
				temp = st.nextToken();
                materialList[i].diffusionG = Float.valueOf(temp.trim()).floatValue();
				temp = st.nextToken();
                materialList[i].diffusionB = Float.valueOf(temp.trim()).floatValue();
				temp = st.nextToken();
                materialList[i].diffusionA = Float.valueOf(temp.trim()).floatValue();
				line = stream3.readLine();
                st = new StringTokenizer(line, ";");
				temp = st.nextToken();
                materialList[i].specularity = Float.valueOf(temp.trim()).floatValue();
				line = stream3.readLine();
                st = new StringTokenizer(line, ";");
				temp = st.nextToken();
                materialList[i].emissionR = Float.valueOf(temp.trim()).floatValue();
				temp = st.nextToken();
                materialList[i].emissionG = Float.valueOf(temp.trim()).floatValue();
				temp = st.nextToken();
                materialList[i].emissionB = Float.valueOf(temp.trim()).floatValue();
				line = stream3.readLine();
                st = new StringTokenizer(line, ";");
				temp = st.nextToken();
                materialList[i].specularityR = Float.valueOf(temp.trim()).floatValue();
				temp = st.nextToken();
                materialList[i].specularityG = Float.valueOf(temp.trim()).floatValue();
				temp = st.nextToken();
                materialList[i].specularityB = Float.valueOf(temp.trim()).floatValue();
				line = stream3.readLine();
				line = stream3.readLine();
                st = new StringTokenizer(line, ";");
				temp = st.nextToken().trim();
				materialList[i].textureFileName = temp.substring(1, temp.length()-1);
            }

        }
        catch (IOException e) {
            System.out.println (e);
        }
    }
}
