//
//  CedJButton.java
//  Puissance3Dj
//
//  Created by SuperCed on Thu Apr 01 2004.
//  Copyright (c) 2004 SuperCed. All rights reserved.
//

import java.awt.* ;
import java.awt.event.* ;

import javax.swing.*;
import javax.swing.event.*;


public class CedJButton extends JButton {
	
	private Puissance3DView masterClass;
	private int ref;
	private boolean buttonEnabled;
	
	public CedJButton() {
		super();
		ref = 0;
		buttonEnabled = true;
		masterClass = null;
	}
	
	public void setButtonEnabled(boolean b) {
		buttonEnabled = b;
	}
	
	public CedJButton(ImageIcon img, Puissance3DView v, int i) {
		super(img);
		
		masterClass = v;
		ref = i;
		this.addMouseListener(new MouseAdapter() {
				 public void mouseExited(MouseEvent evt) {
					if (buttonEnabled) {
						masterClass.processMouseExit(ref);
					}
				 }
				 public void mouseEntered(MouseEvent evt) {
					if (buttonEnabled) {
						masterClass.processMouseEnter(ref);
					}
				 }
				 public void mouseClicked(MouseEvent evt) {
					if (buttonEnabled) {
						masterClass.processMouseClick(ref);
					}
				 }
				}
		);
	}	
}
