/*
 * Decompiled with CFR 0.152.
 */
import com.sun.j3d.utils.behaviors.mouse.MouseRotate;
import com.sun.j3d.utils.behaviors.mouse.MouseTranslate;
import com.sun.j3d.utils.behaviors.mouse.MouseZoom;
import com.sun.j3d.utils.image.TextureLoader;
import com.sun.j3d.utils.universe.SimpleUniverse;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GraphicsConfiguration;
import java.awt.GridBagConstraints;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Hashtable;
import java.util.ResourceBundle;
import javax.media.j3d.Appearance;
import javax.media.j3d.BoundingSphere;
import javax.media.j3d.Bounds;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Canvas3D;
import javax.media.j3d.ColoringAttributes;
import javax.media.j3d.DirectionalLight;
import javax.media.j3d.Geometry;
import javax.media.j3d.LineAttributes;
import javax.media.j3d.Material;
import javax.media.j3d.Node;
import javax.media.j3d.PolygonAttributes;
import javax.media.j3d.Shape3D;
import javax.media.j3d.Texture;
import javax.media.j3d.Texture2D;
import javax.media.j3d.TextureAttributes;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.media.j3d.TransparencyAttributes;
import javax.media.j3d.TriangleArray;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;
import javax.vecmath.Color3f;
import javax.vecmath.Color4f;
import javax.vecmath.Point3d;
import javax.vecmath.Point3f;
import javax.vecmath.TexCoord2f;
import javax.vecmath.Vector3f;

public class Puissance3DView
extends JFrame
implements Runnable {
    private Transform3D rotate1 = new Transform3D();
    private Transform3D rotate2 = new Transform3D();
    private Transform3D rotate3 = new Transform3D();
    private Transform3D rotate4 = new Transform3D();
    private Transform3D rotate5 = new Transform3D();
    private Transform3D rotate6 = new Transform3D();
    private Transform3D translate1 = new Transform3D();
    private Transform3D translate2 = new Transform3D();
    private Transform3D translate3 = new Transform3D();
    private Object3DX table;
    private Object3DX baton;
    private Object3DX greenPerl;
    private Object3DX pinkPerl;
    private TriangleArray triangle;
    private Vertex v;
    private Canvas3D canvas3D;
    private boolean transparencyFlag;
    private Texture2D texture;
    private float transparencyFactor;
    private Shape3D[] pinkPerls = new Shape3D[64];
    private Shape3D[] greenPerls = new Shape3D[64];
    private Hashtable objectsDictionary = new Hashtable();
    private Hashtable texturesDictionary = new Hashtable();
    private CedJButton[] buttonsList;
    private JButton seeLastPerl;
    private JLabel infoLabel;
    private JProgressBar gameProgressBar;
    private JButton stopButton;
    private JPanel leftPanel;
    private JPanel topLeftPanel;
    private JPanel bottomLeftPanel;
    private ImageIcon roseRollover;
    private ImageIcon roseDown;
    private ImageIcon greenRollover;
    private ImageIcon greenDown;
    private ResourceBundle resbundle;
    private int playerNumber;
    private Puissance3Dj mainWindow;
    private int difficultyLevel;
    private int player;
    private int nbPerlPut = 0;
    private int line;
    private char[] perlArrayRepresentation;
    private char[] perlArrayRepresentationCache;
    private Object me = this;
    private Thread computerThinks;
    private int progressBarValue;
    private int lastPerl = -1;

    public Puissance3DView() {
        super("Puissance3DView");
        this.perlArrayRepresentation = new char[64];
        this.perlArrayRepresentationCache = new char[64];
        this.canvas3D = this.createCanvas3D();
        this.table = new Object3DX("objects/plaque.x");
        this.baton = new Object3DX("objects/batonnet.x");
        this.greenPerl = new Object3DX("objects/perleverte.x");
        this.pinkPerl = new Object3DX("objects/perlerose.x");
        BranchGroup branchGroup = this.createSceneGraph();
        SimpleUniverse simpleUniverse = new SimpleUniverse(this.canvas3D);
        simpleUniverse.addBranchGraph(branchGroup);
        simpleUniverse.getViewingPlatform().setNominalViewingTransform();
        Transform3D transform3D = new Transform3D();
        transform3D.set(new Vector3f(0.0f, 0.0f, 0.9f));
        this.rotate5.rotX(-0.7853981633974483);
        this.rotate5.mul(transform3D);
        simpleUniverse.getViewingPlatform().getViewPlatformTransform().setTransform(this.rotate5);
        this.canvas3D.getView().setTransparencySortingPolicy(1);
        this.canvas3D.getView().setSceneAntialiasingEnable(false);
        this.canvas3D.getView().setFrontClipDistance(0.01);
        this.setSize(600, 400);
        this.gameProgressBar.setValue(16);
        this.setEnableInterface(true);
        this.player = 0;
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation((dimension.width - this.getSize().width) / 2, (dimension.height - this.getSize().height) / 2);
    }

    public void setResBundle(ResourceBundle resourceBundle) {
        this.resbundle = resourceBundle;
    }

    public void setPlayerNumber(int n) {
        this.playerNumber = n;
    }

    public void initGame() {
        this.nbPerlPut = 0;
        for (int i = 0; i < 64; ++i) {
            this.perlArrayRepresentation[i] = '\u0000';
            this.perlArrayRepresentationCache[i] = '\u0000';
            TransparencyAttributes transparencyAttributes = this.pinkPerls[i].getAppearance().getTransparencyAttributes();
            transparencyAttributes.setTransparencyMode(1);
            transparencyAttributes.setTransparency(1.0f);
            TransparencyAttributes transparencyAttributes2 = this.greenPerls[i].getAppearance().getTransparencyAttributes();
            transparencyAttributes2.setTransparencyMode(1);
            transparencyAttributes2.setTransparency(1.0f);
        }
        this.setIconsColor(false);
        this.seeLastPerl.setText(this.resbundle.getString("seeLastPerl"));
        this.infoLabel.setText(this.resbundle.getString("yourTurn"));
        this.stopButton.setText(this.resbundle.getString("stopButton"));
        this.setTitle(this.resbundle.getString("frameConstructorView"));
        this.player = 1;
    }

    public void refreshPerls() {
        int n = 0;
        boolean bl = false;
        if (n < 64 && this.perlArrayRepresentation[n] == this.perlArrayRepresentationCache[n]) {
            bl = true;
        }
        while (bl) {
            bl = false;
            if (++n >= 64 || this.perlArrayRepresentation[n] != this.perlArrayRepresentationCache[n]) continue;
            bl = true;
        }
        if (n > 63) {
            return;
        }
        this.perlArrayRepresentationCache[n] = this.perlArrayRepresentation[n];
        switch (this.perlArrayRepresentation[n]) {
            case '\u0000': {
                TransparencyAttributes transparencyAttributes = this.pinkPerls[n].getAppearance().getTransparencyAttributes();
                transparencyAttributes.setTransparencyMode(1);
                transparencyAttributes.setTransparency(1.0f);
                TransparencyAttributes transparencyAttributes2 = this.greenPerls[n].getAppearance().getTransparencyAttributes();
                transparencyAttributes2.setTransparencyMode(1);
                transparencyAttributes2.setTransparency(1.0f);
                break;
            }
            case '\u0001': {
                this.pinkPerls[n].getAppearance().getTransparencyAttributes().setTransparencyMode(4);
                TransparencyAttributes transparencyAttributes = this.greenPerls[n].getAppearance().getTransparencyAttributes();
                transparencyAttributes.setTransparencyMode(1);
                transparencyAttributes.setTransparency(1.0f);
                break;
            }
            case '\u0002': {
                this.greenPerls[n].getAppearance().getTransparencyAttributes().setTransparencyMode(4);
                TransparencyAttributes transparencyAttributes = this.pinkPerls[n].getAppearance().getTransparencyAttributes();
                transparencyAttributes.setTransparencyMode(1);
                transparencyAttributes.setTransparency(1.0f);
                break;
            }
            case '\u0003': {
                TransparencyAttributes transparencyAttributes = this.pinkPerls[n].getAppearance().getTransparencyAttributes();
                transparencyAttributes.setTransparencyMode(1);
                transparencyAttributes.setTransparency(0.3f);
                TransparencyAttributes transparencyAttributes3 = this.greenPerls[n].getAppearance().getTransparencyAttributes();
                transparencyAttributes3.setTransparencyMode(1);
                transparencyAttributes3.setTransparency(1.0f);
                break;
            }
            case '\u0004': {
                TransparencyAttributes transparencyAttributes = this.pinkPerls[n].getAppearance().getTransparencyAttributes();
                transparencyAttributes.setTransparencyMode(1);
                transparencyAttributes.setTransparency(1.0f);
                TransparencyAttributes transparencyAttributes4 = this.greenPerls[n].getAppearance().getTransparencyAttributes();
                transparencyAttributes4.setTransparencyMode(1);
                transparencyAttributes4.setTransparency(0.3f);
            }
        }
    }

    public Insets insets() {
        return new Insets(30, 10, 10, 10);
    }

    public void setMainWindow(Puissance3Dj puissance3Dj) {
        this.mainWindow = puissance3Dj;
    }

    public void setLevel(int n) {
        this.difficultyLevel = n;
    }

    private Canvas3D createCanvas3D() {
        this.setSize(300, 300);
        BorderLayout borderLayout = new BorderLayout(20, 20);
        this.getContentPane().setLayout(borderLayout);
        GraphicsConfiguration graphicsConfiguration = SimpleUniverse.getPreferredConfiguration();
        Canvas3D canvas3D = new Canvas3D(graphicsConfiguration);
        this.setSize(600, 300);
        this.getContentPane().add((Component)canvas3D, "Center");
        this.leftPanel = new JPanel();
        BorderLayout borderLayout2 = new BorderLayout();
        this.leftPanel.setLayout(borderLayout2);
        this.topLeftPanel = new JPanel();
        this.getContentPane().add((Component)this.leftPanel, "East");
        this.bottomLeftPanel = new JPanel();
        this.leftPanel.add((Component)this.topLeftPanel, "North");
        this.leftPanel.add((Component)this.bottomLeftPanel, "South");
        TextureLoader textureLoader = new TextureLoader(this.getClass().getResource("images/baton.tif"), null);
        ImageIcon imageIcon = new ImageIcon(textureLoader.getImage().getImage());
        TextureLoader textureLoader2 = new TextureLoader(this.getClass().getResource("images/batonroseover.tif"), null);
        this.roseRollover = new ImageIcon(textureLoader2.getImage().getImage());
        TextureLoader textureLoader3 = new TextureLoader(this.getClass().getResource("images/batonrosedown.tif"), null);
        this.roseDown = new ImageIcon(textureLoader3.getImage().getImage());
        TextureLoader textureLoader4 = new TextureLoader(this.getClass().getResource("images/batonverteover.tif"), null);
        this.greenRollover = new ImageIcon(textureLoader4.getImage().getImage());
        TextureLoader textureLoader5 = new TextureLoader(this.getClass().getResource("images/batonvertedown.tif"), null);
        this.greenDown = new ImageIcon(textureLoader5.getImage().getImage());
        GridLayout gridLayout = new GridLayout(4, 4);
        this.topLeftPanel.setLayout(gridLayout);
        this.buttonsList = new CedJButton[16];
        for (int i = 0; i < 16; ++i) {
            this.buttonsList[i] = new CedJButton(imageIcon, this, i);
            this.buttonsList[i].setRolloverEnabled(true);
            this.buttonsList[i].setBorder(BorderFactory.createEmptyBorder());
            this.topLeftPanel.add(this.buttonsList[i]);
        }
        this.setIconsColor(false);
        GridLayout gridLayout2 = new GridLayout(4, 1);
        this.bottomLeftPanel.setLayout(gridLayout2);
        this.seeLastPerl = new JButton("See Last Perl");
        this.bottomLeftPanel.add(this.seeLastPerl);
        this.seeLastPerl.addMouseListener(new MouseListener(){

            public void mousePressed(MouseEvent mouseEvent) {
                if (Puissance3DView.this.lastPerl != -1) {
                    char[] cArray = Puissance3DView.this.perlArrayRepresentation;
                    int n = Puissance3DView.this.lastPerl;
                    cArray[n] = (char)(cArray[n] + 2);
                    Puissance3DView.this.refreshPerls();
                }
            }

            public void mouseClicked(MouseEvent mouseEvent) {
            }

            public void mouseReleased(MouseEvent mouseEvent) {
                if (Puissance3DView.this.lastPerl != -1) {
                    char[] cArray = Puissance3DView.this.perlArrayRepresentation;
                    int n = Puissance3DView.this.lastPerl;
                    cArray[n] = (char)(cArray[n] - 2);
                    Puissance3DView.this.refreshPerls();
                }
            }

            public void mouseEntered(MouseEvent mouseEvent) {
            }

            public void mouseExited(MouseEvent mouseEvent) {
            }
        });
        this.infoLabel = new JLabel("Your turn");
        this.bottomLeftPanel.add(this.infoLabel);
        this.gameProgressBar = new JProgressBar(0, 15);
        this.bottomLeftPanel.add(this.gameProgressBar);
        this.stopButton = new JButton("Stop Button");
        this.stopButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Puissance3DView.this.mainWindow.setVisible(true);
                ((Puissance3DView)Puissance3DView.this.me).setVisible(false);
            }
        });
        this.bottomLeftPanel.add(this.stopButton);
        return canvas3D;
    }

    public void processMouseEnter(int n) {
        char c;
        int n2 = 0;
        boolean bl = false;
        if (n2 < 64 && ((c = this.perlArrayRepresentation[n + n2]) == '\u0001' || c == '\u0002')) {
            bl = true;
        }
        while (bl) {
            bl = false;
            if ((n2 += 16) >= 64 || (c = this.perlArrayRepresentation[n + n2]) != '\u0001' && c != '\u0002') continue;
            bl = true;
        }
        if (n2 > 63) {
            return;
        }
        switch (this.player) {
            case 1: {
                this.perlArrayRepresentation[n + n2] = 3;
                break;
            }
            case 2: {
                this.perlArrayRepresentation[n + n2] = 4;
            }
        }
        this.refreshPerls();
    }

    public void processMouseExit(int n) {
        int n2 = 0;
        boolean bl = false;
        if (n2 < 64 && (this.perlArrayRepresentation[n + n2] == '\u0001' || this.perlArrayRepresentation[n + n2] == '\u0002')) {
            bl = true;
        }
        while (bl) {
            bl = false;
            if ((n2 += 16) >= 64 || this.perlArrayRepresentation[n + n2] != '\u0001' && this.perlArrayRepresentation[n + n2] != '\u0002') continue;
            bl = true;
        }
        if (n2 > 63) {
            return;
        }
        if (this.perlArrayRepresentation[n + n2] > '\u0002') {
            this.perlArrayRepresentation[n + n2] = '\u0000';
        }
        this.refreshPerls();
    }

    public void processMouseClick(int n) {
        int n2 = 0;
        boolean bl = false;
        if (n2 < 64 && (this.perlArrayRepresentation[n + n2] == '\u0001' || this.perlArrayRepresentation[n + n2] == '\u0002')) {
            bl = true;
        }
        while (bl) {
            bl = false;
            if ((n2 += 16) >= 64 || this.perlArrayRepresentation[n + n2] != '\u0001' && this.perlArrayRepresentation[n + n2] != '\u0002') continue;
            bl = true;
        }
        if (n2 > 63) {
            return;
        }
        ++this.nbPerlPut;
        this.lastPerl = -1;
        switch (this.player) {
            case 1: {
                this.perlArrayRepresentation[n + n2] = '\u0001';
                this.lastPerl = n + n2;
                this.refreshPerls();
                if (this.checkWinner() == 1) {
                    this.illuminateLine(this.line);
                    this.setEnableInterface(false);
                    if (this.playerNumber == 1) {
                        this.infoLabel.setText(this.resbundle.getString("youWin"));
                        CedJDialog cedJDialog = new CedJDialog(this, this.resbundle.getString("youWin"), true);
                        cedJDialog.setVisible(true);
                    } else {
                        this.infoLabel.setText(this.resbundle.getString("player1Wins"));
                        CedJDialog cedJDialog = new CedJDialog(this, this.resbundle.getString("player1Wins"), true);
                        cedJDialog.setVisible(true);
                    }
                    return;
                }
                if (this.nbPerlPut == 64) {
                    this.setEnableInterface(false);
                    this.infoLabel.setText(this.resbundle.getString("equality"));
                    CedJDialog cedJDialog = new CedJDialog(this, this.resbundle.getString("equality"), true);
                    cedJDialog.setVisible(true);
                    cedJDialog.pack();
                    return;
                }
                if (this.playerNumber == 1) {
                    this.infoLabel.setText(this.resbundle.getString("computerIsThinking"));
                    this.setEnableInterface(false);
                    this.computerThinks = new Thread(this);
                    this.computerThinks.start();
                    break;
                }
                this.infoLabel.setText(this.resbundle.getString("player2Turn"));
                this.setIconsColor(true);
                this.player = 2;
                break;
            }
            case 2: {
                this.perlArrayRepresentation[n + n2] = 2;
                this.lastPerl = n + n2;
                this.refreshPerls();
                if (this.checkWinner() == 2) {
                    this.illuminateLine(this.line);
                    this.setEnableInterface(false);
                    this.infoLabel.setText(this.resbundle.getString("player2Wins"));
                    CedJDialog cedJDialog = new CedJDialog(this, this.resbundle.getString("player2Wins"), true);
                    cedJDialog.setVisible(true);
                    cedJDialog.pack();
                    return;
                }
                if (this.nbPerlPut == 64) {
                    this.setEnableInterface(false);
                    this.infoLabel.setText(this.resbundle.getString("equality"));
                    CedJDialog cedJDialog = new CedJDialog(this, this.resbundle.getString("equality"), true);
                    cedJDialog.setVisible(true);
                    cedJDialog.pack();
                    return;
                }
                this.player = 1;
                this.infoLabel.setText(this.resbundle.getString("player1Turn"));
                this.setIconsColor(false);
            }
        }
    }

    public void run() {
        this.computerThinks();
    }

    public void computerThinks() {
        boolean bl;
        int n;
        char[] cArray = new char[64];
        this.line = -1;
        int n2 = this.difficultyLevel;
        if (n2 > 64 - this.nbPerlPut) {
            n2 = 64 - this.nbPerlPut;
        }
        int n3 = -268435456;
        int n4 = 0;
        this.progressBarValue = 0;
        Runnable runnable = new Runnable(){

            public void run() {
                Puissance3DView.this.gameProgressBar.setValue(Puissance3DView.this.progressBarValue);
            }
        };
        try {
            SwingUtilities.invokeLater(runnable);
        }
        catch (Exception exception) {
            System.out.println(exception);
        }
        for (int i = 0; i < 16; ++i) {
            int n5;
            this.progressBarValue = i;
            try {
                SwingUtilities.invokeAndWait(runnable);
            }
            catch (Exception exception) {
                System.out.println(exception);
            }
            cArray = (char[])this.perlArrayRepresentation.clone();
            n = 0;
            for (n5 = 0; n5 < 64; ++n5) {
                if (cArray[n5] <= '\u0002') continue;
                cArray[n5] = '\u0000';
            }
            bl = false;
            if (n < 4 && cArray[i + n * 16] != '\u0000') {
                bl = true;
            }
            while (bl) {
                bl = false;
                if (++n >= 4 || cArray[i + n * 16] == '\u0000') continue;
                bl = true;
            }
            if (n >= 4) continue;
            n5 = i + n * 16;
            cArray[n5] = 2;
            int n6 = this.minMaxAlphaBeta(n2, cArray, n3, 0x1000000);
            if (n6 < n3) continue;
            n3 = n6;
            n4 = i;
        }
        n = 0;
        bl = false;
        if (n < 64 && (this.perlArrayRepresentation[n4 + n] == '\u0001' || this.perlArrayRepresentation[n4 + n] == '\u0002')) {
            bl = true;
        }
        while (bl) {
            bl = false;
            if ((n += 16) >= 64 || this.perlArrayRepresentation[n4 + n] != '\u0001' && this.perlArrayRepresentation[n4 + n] != '\u0002') continue;
            bl = true;
        }
        if (n > 63) {
            return;
        }
        this.perlArrayRepresentation[n4 + n] = 2;
        this.lastPerl = n4 + n;
        this.gameProgressBar.setValue(16);
        this.repaint();
        this.refreshPerls();
        ++this.nbPerlPut;
        if (this.checkWinner() == 2) {
            this.illuminateLine(this.line);
            this.setEnableInterface(false);
            this.infoLabel.setText(this.resbundle.getString("computerWins"));
            CedJDialog cedJDialog = new CedJDialog(this, this.resbundle.getString("computerWins"), true);
            cedJDialog.setVisible(true);
            cedJDialog.pack();
            return;
        }
        if (this.nbPerlPut == 64) {
            this.setEnableInterface(false);
            this.infoLabel.setText(this.resbundle.getString("equality"));
            CedJDialog cedJDialog = new CedJDialog(this, this.resbundle.getString("equality"), true);
            cedJDialog.setVisible(true);
            cedJDialog.pack();
            return;
        }
        this.setEnableInterface(true);
        this.infoLabel.setText(this.resbundle.getString("yourTurn"));
    }

    private int checkWinner() {
        int n;
        char[] cArray = (char[])this.perlArrayRepresentation.clone();
        for (n = 0; n < 64; ++n) {
            if (cArray[n] <= '\u0002') continue;
            cArray[n] = '\u0000';
        }
        n = this.evaluationFunction(cArray);
        switch (n) {
            case 0x1000000: {
                return 2;
            }
            case -268435456: {
                return 1;
            }
        }
        return 0;
    }

    private void setIconsColor(boolean bl) {
        if (bl) {
            for (int i = 0; i < 16; ++i) {
                this.buttonsList[i].setPressedIcon(this.roseDown);
                this.buttonsList[i].setRolloverIcon(this.roseRollover);
            }
        } else {
            for (int i = 0; i < 16; ++i) {
                this.buttonsList[i].setPressedIcon(this.greenDown);
                this.buttonsList[i].setRolloverIcon(this.greenRollover);
            }
        }
    }

    private void setEnableInterface(boolean bl) {
        for (int i = 0; i < 16; ++i) {
            this.buttonsList[i].setEnabled(bl);
            this.buttonsList[i].setButtonEnabled(bl);
        }
        this.seeLastPerl.setEnabled(bl);
    }

    private GridBagConstraints createGridBagConstraints(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = n;
        gridBagConstraints.gridy = n2;
        gridBagConstraints.gridwidth = n3;
        gridBagConstraints.gridheight = n4;
        gridBagConstraints.weightx = n5;
        gridBagConstraints.weighty = n6;
        gridBagConstraints.ipadx = n7;
        gridBagConstraints.ipady = n8;
        gridBagConstraints.fill = n9;
        gridBagConstraints.anchor = n10;
        return gridBagConstraints;
    }

    private BranchGroup createSceneGraph() {
        TransformGroup transformGroup;
        DirectionalLight directionalLight;
        Shape3D shape3D;
        BranchGroup branchGroup = new BranchGroup();
        TransformGroup transformGroup2 = new TransformGroup();
        transformGroup2.setCapability(18);
        transformGroup2.setCapability(17);
        BoundingSphere boundingSphere = new BoundingSphere(new Point3d(), 10.0);
        MouseRotate mouseRotate = new MouseRotate(transformGroup2);
        mouseRotate.setSchedulingBounds((Bounds)boundingSphere);
        MouseTranslate mouseTranslate = new MouseTranslate(transformGroup2);
        mouseTranslate.setSchedulingBounds((Bounds)boundingSphere);
        MouseZoom mouseZoom = new MouseZoom(transformGroup2);
        mouseZoom.setSchedulingBounds((Bounds)boundingSphere);
        branchGroup.addChild((Node)mouseRotate);
        branchGroup.addChild((Node)mouseTranslate);
        branchGroup.addChild((Node)mouseZoom);
        this.transparencyFlag = false;
        branchGroup.addChild((Node)transformGroup2);
        transformGroup2.addChild((Node)this.addObject(this.table));
        float f = 0.12f;
        float f2 = 0.02f;
        float f3 = 0.2f;
        Shape3D shape3D2 = this.addObject(this.baton);
        for (int i = 0; i < 16; ++i) {
            if (i % 4 == 0) {
                f -= 0.32f;
                f3 -= 0.08f;
            }
            shape3D = new Vector3f(f += 0.08f, f2, f3);
            this.translate1 = new Transform3D();
            this.translate1.setTranslation((Vector3f)shape3D);
            TransformGroup transformGroup3 = new TransformGroup(this.translate1);
            transformGroup3.addChild(shape3D2.cloneNode(true));
            transformGroup2.addChild((Node)transformGroup3);
        }
        this.transparencyFlag = true;
        Shape3D shape3D3 = this.addObject(this.greenPerl);
        shape3D = this.addObject(this.pinkPerl);
        f2 -= 0.01f;
        f3 += 0.24f;
        for (int i = 0; i < 64; ++i) {
            if (i % 16 == 0) {
                f2 += 0.02f;
                f3 -= 0.32f;
            }
            if (i % 4 == 0) {
                f -= 0.32f;
                f3 += 0.08f;
            }
            directionalLight = new Vector3f(f += 0.08f, f2, f3);
            this.translate1 = new Transform3D();
            this.translate1.setTranslation((Vector3f)directionalLight);
            transformGroup = new TransformGroup(this.translate1);
            this.transparencyFlag = true;
            this.pinkPerls[i] = this.addObject(this.greenPerl);
            this.greenPerls[i] = this.addObject(this.pinkPerl);
            transformGroup.addChild((Node)this.pinkPerls[i]);
            transformGroup.addChild((Node)this.greenPerls[i]);
            transformGroup2.addChild((Node)transformGroup);
        }
        Color3f color3f = new Color3f(1.0f, 1.0f, 0.9f);
        directionalLight = new DirectionalLight(color3f, new Vector3f(-1.0f, -1.0f, 1.0f));
        directionalLight.setInfluencingBounds((Bounds)new BoundingSphere(new Point3d(), 5.0));
        transformGroup = new DirectionalLight(color3f, new Vector3f(0.0f, -1.0f, -1.0f));
        transformGroup.setInfluencingBounds((Bounds)new BoundingSphere(new Point3d(), 10.0));
        branchGroup.addChild((Node)directionalLight);
        branchGroup.addChild((Node)transformGroup);
        branchGroup.compile();
        return branchGroup;
    }

    private Shape3D addObject(Object3DX object3DX) {
        TextureAttributes textureAttributes;
        Shape3D shape3D = new Shape3D();
        if (this.objectsDictionary.containsKey(object3DX.name)) {
            Shape3D shape3D2 = (Shape3D)this.objectsDictionary.get(object3DX.name);
            shape3D.setGeometry(shape3D2.getGeometry());
            Appearance appearance = shape3D2.getAppearance();
            Appearance appearance2 = new Appearance();
            shape3D.setCapability(14);
            shape3D.setCapability(15);
            shape3D.setAppearance(appearance2);
            appearance2.setMaterial(appearance.getMaterial());
            appearance2.setColoringAttributes(appearance.getColoringAttributes());
            appearance2.setLineAttributes(appearance.getLineAttributes());
            appearance2.setPolygonAttributes(appearance.getPolygonAttributes());
            appearance2.setCapability(10);
            appearance2.setCapability(11);
            if (this.transparencyFlag) {
                TransparencyAttributes transparencyAttributes = new TransparencyAttributes();
                transparencyAttributes.setTransparencyMode(1);
                this.transparencyFactor = 0.5f;
                transparencyAttributes.setCapability(2);
                transparencyAttributes.setCapability(3);
                transparencyAttributes.setCapability(0);
                transparencyAttributes.setCapability(1);
                transparencyAttributes.setTransparency(this.transparencyFactor);
                appearance2.setTransparencyAttributes(transparencyAttributes);
            }
            appearance2.setTexture(appearance.getTexture());
            appearance2.setTextureAttributes(appearance.getTextureAttributes());
            return shape3D;
        }
        this.triangle = new TriangleArray(object3DX.nbTriangles * 3, 35);
        int n = 0;
        int n2 = 0;
        while (n < object3DX.nbTriangles * 3) {
            this.v = object3DX.vertexList[object3DX.triangleList[n2].a];
            this.triangle.setCoordinate(n, new Point3f(this.v.x, this.v.y, this.v.z));
            this.triangle.setNormal(n, new Vector3f(this.v.nx, this.v.ny, this.v.nz));
            this.triangle.setTextureCoordinate(0, n, new TexCoord2f(this.v.u, this.v.v));
            this.v = object3DX.vertexList[object3DX.triangleList[n2].b];
            this.triangle.setCoordinate(++n, new Point3f(this.v.x, this.v.y, this.v.z));
            this.triangle.setNormal(n, new Vector3f(this.v.nx, this.v.ny, this.v.nz));
            this.triangle.setTextureCoordinate(0, n, new TexCoord2f(this.v.u, this.v.v));
            this.v = object3DX.vertexList[object3DX.triangleList[n2].c];
            this.triangle.setCoordinate(++n, new Point3f(this.v.x, this.v.y, this.v.z));
            this.triangle.setNormal(n, new Vector3f(this.v.nx, this.v.ny, this.v.nz));
            this.triangle.setTextureCoordinate(0, n, new TexCoord2f(this.v.u, this.v.v));
            ++n;
            ++n2;
        }
        shape3D.setGeometry((Geometry)this.triangle);
        Appearance appearance = new Appearance();
        appearance.setMaterial(new Material());
        CedMaterial cedMaterial = object3DX.materialList[object3DX.triangleList[n2 - 1].material];
        if (this.texturesDictionary.contains(cedMaterial.textureFileName)) {
            this.texture = (Texture2D)this.texturesDictionary.get(cedMaterial.textureFileName);
        } else {
            textureAttributes = new TextureLoader(this.getClass().getResource("textures/" + cedMaterial.textureFileName), null);
            this.texture = (Texture2D)textureAttributes.getTexture();
            this.texturesDictionary.put(cedMaterial.textureFileName, this.texture);
        }
        textureAttributes = new TextureAttributes();
        textureAttributes.setTextureMode(2);
        textureAttributes.setTextureBlendColor(new Color4f(0.0f, 0.0f, 0.0f, 0.0f));
        textureAttributes.setPerspectiveCorrectionMode(1);
        ColoringAttributes coloringAttributes = new ColoringAttributes();
        coloringAttributes.setCapability(2);
        coloringAttributes.setCapability(3);
        coloringAttributes.setShadeModel(3);
        appearance.setColoringAttributes(coloringAttributes);
        LineAttributes lineAttributes = new LineAttributes(2.0f, 0, true);
        lineAttributes.setLineAntialiasingEnable(false);
        lineAttributes.setCapability(4);
        lineAttributes.setCapability(5);
        appearance.setLineAttributes(lineAttributes);
        PolygonAttributes polygonAttributes = new PolygonAttributes();
        polygonAttributes.setCullFace(0);
        appearance.setPolygonAttributes(polygonAttributes);
        if (this.transparencyFlag) {
            TransparencyAttributes transparencyAttributes = new TransparencyAttributes();
            transparencyAttributes.setTransparencyMode(1);
            this.transparencyFactor = 0.5f;
            transparencyAttributes.setCapability(2);
            transparencyAttributes.setCapability(3);
            transparencyAttributes.setCapability(0);
            transparencyAttributes.setCapability(1);
            transparencyAttributes.setTransparency(this.transparencyFactor);
            appearance.setTransparencyAttributes(transparencyAttributes);
        }
        appearance.setCapability(8);
        appearance.setCapability(16);
        appearance.setCapability(0);
        appearance.setCapability(10);
        appearance.setCapability(11);
        appearance.setTexture((Texture)this.texture);
        appearance.setTextureAttributes(textureAttributes);
        shape3D.setAppearance(appearance);
        shape3D.setCapability(14);
        shape3D.setCapability(15);
        this.objectsDictionary.put(object3DX.name, shape3D);
        return shape3D;
    }

    private int evaluationFunction(char[] cArray) {
        char c;
        int n;
        int n2;
        char c2;
        char c3;
        char c4;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        int n8;
        int n9;
        int n10;
        int n11 = 0;
        this.line = -1;
        for (n10 = 0; n10 < 4; ++n10) {
            for (n9 = 0; n9 < 4; ++n9) {
                n8 = 0;
                n7 = 0;
                n6 = 0;
                n5 = 0;
                n4 = 0;
                n3 = 0;
                for (int i = 0; i < 4; ++i) {
                    c4 = cArray[n10 * 16 + n9 * 4 + i];
                    c3 = cArray[n10 * 16 + n9 + i * 4];
                    c2 = cArray[n10 + n9 * 4 + i * 16];
                    if (c4 != '\u0000') {
                        if (c4 == '\u0001') {
                            ++n8;
                        } else {
                            ++n7;
                        }
                    }
                    if (c3 != '\u0000') {
                        if (c3 == '\u0001') {
                            ++n6;
                        } else {
                            ++n5;
                        }
                    }
                    if (c2 == '\u0000') continue;
                    if (c2 == '\u0001') {
                        ++n4;
                        continue;
                    }
                    ++n3;
                }
                if (n8 == 4) {
                    this.line = n10 * 4 + n9;
                    return -268435456;
                }
                if (n7 == 4) {
                    this.line = n10 * 4 + n9;
                    return 0x1000000;
                }
                if (n6 == 4) {
                    this.line = n10 * 4 + n9 + 16;
                    return -268435456;
                }
                if (n5 == 4) {
                    this.line = n10 * 4 + n9 + 16;
                    return 0x1000000;
                }
                if (n4 == 4) {
                    this.line = n10 * 4 + n9 + 32;
                    return -268435456;
                }
                if (n3 == 4) {
                    this.line = n10 * 4 + n9 + 32;
                    return 0x1000000;
                }
                n11 += this.evaluateNumbers(n8, n7);
                n11 += this.evaluateNumbers(n6, n5);
                n11 += this.evaluateNumbers(n4, n3);
            }
        }
        for (n10 = 0; n10 < 4; ++n10) {
            n8 = 0;
            n7 = 0;
            n6 = 0;
            n5 = 0;
            n4 = 0;
            n3 = 0;
            n2 = 0;
            n = 0;
            for (n9 = 0; n9 < 4; ++n9) {
                c4 = cArray[n10 * 4 + n9 * 16 + n9];
                c3 = cArray[n10 * 4 + (3 - n9) * 16 + n9];
                c2 = cArray[n9 * 4 + n9 * 16 + n10];
                c = cArray[n9 * 4 + (3 - n9) * 16 + n10];
                if (c4 != '\u0000') {
                    if (c4 == '\u0001') {
                        ++n8;
                    } else {
                        ++n7;
                    }
                }
                if (c3 != '\u0000') {
                    if (c3 == '\u0001') {
                        ++n6;
                    } else {
                        ++n5;
                    }
                }
                if (c2 != '\u0000') {
                    if (c2 == '\u0001') {
                        ++n4;
                    } else {
                        ++n3;
                    }
                }
                if (c == '\u0000') continue;
                if (c == '\u0001') {
                    ++n2;
                    continue;
                }
                ++n;
            }
            if (n8 == 4) {
                this.line = n10 + 48;
                return -268435456;
            }
            if (n7 == 4) {
                this.line = n10 + 48;
                return 0x1000000;
            }
            if (n6 == 4) {
                this.line = n10 + 52;
                return -268435456;
            }
            if (n5 == 4) {
                this.line = n10 + 52;
                return 0x1000000;
            }
            if (n4 == 4) {
                this.line = n10 + 56;
                return -268435456;
            }
            if (n3 == 4) {
                this.line = n10 + 56;
                return 0x1000000;
            }
            if (n2 == 4) {
                this.line = n10 + 60;
                return -268435456;
            }
            if (n == 4) {
                this.line = n10 + 60;
                return 0x1000000;
            }
            n11 += this.evaluateNumbers(n8, n7);
            n11 += this.evaluateNumbers(n6, n5);
            n11 += this.evaluateNumbers(n4, n3);
            n11 += this.evaluateNumbers(n2, n);
        }
        for (n10 = 0; n10 < 4; ++n10) {
            n8 = 0;
            n7 = 0;
            n6 = 0;
            n5 = 0;
            for (n9 = 0; n9 < 4; ++n9) {
                c4 = cArray[n10 * 16 + n9 * 4 + n9];
                c3 = cArray[n10 * 16 + (3 - n9) * 4 + n9];
                if (c4 != '\u0000') {
                    if (c4 == '\u0001') {
                        ++n8;
                    } else {
                        ++n7;
                    }
                }
                if (c3 == '\u0000') continue;
                if (c3 == '\u0001') {
                    ++n6;
                    continue;
                }
                ++n5;
            }
            if (n8 == 4) {
                this.line = n10 + 64;
                return -268435456;
            }
            if (n7 == 4) {
                this.line = n10 + 64;
                return 0x1000000;
            }
            if (n6 == 4) {
                this.line = n10 + 68;
                return -268435456;
            }
            if (n5 == 4) {
                this.line = n10 + 68;
                return 0x1000000;
            }
            n11 += this.evaluateNumbers(n8, n7);
            n11 += this.evaluateNumbers(n6, n5);
        }
        n8 = 0;
        n7 = 0;
        n6 = 0;
        n5 = 0;
        n4 = 0;
        n3 = 0;
        n2 = 0;
        n = 0;
        for (n10 = 0; n10 < 4; ++n10) {
            c4 = cArray[n10 * 16 + n10 * 4 + n10];
            c3 = cArray[(3 - n10) * 16 + n10 * 4 + n10];
            c2 = cArray[n10 * 16 + n10 * 4 + (3 - n10)];
            c = cArray[(3 - n10) * 16 + n10 * 4 + (3 - n10)];
            if (c4 != '\u0000') {
                if (c4 == '\u0001') {
                    ++n8;
                } else {
                    ++n7;
                }
            }
            if (c3 != '\u0000') {
                if (c3 == '\u0001') {
                    ++n6;
                } else {
                    ++n5;
                }
            }
            if (c2 != '\u0000') {
                if (c2 == '\u0001') {
                    ++n4;
                } else {
                    ++n3;
                }
            }
            if (c == '\u0000') continue;
            if (c == '\u0001') {
                ++n2;
                continue;
            }
            ++n;
        }
        if (n8 == 4) {
            this.line = 72;
            return -268435456;
        }
        if (n7 == 4) {
            this.line = 72;
            return -16777216;
        }
        if (n6 == 4) {
            this.line = 73;
            return -268435456;
        }
        if (n5 == 4) {
            this.line = 73;
            return 0x1000000;
        }
        if (n4 == 4) {
            this.line = 74;
            return -268435456;
        }
        if (n3 == 4) {
            this.line = 74;
            return 0x1000000;
        }
        if (n2 == 4) {
            this.line = 75;
            return -268435456;
        }
        if (n == 4) {
            this.line = 75;
            return 0x1000000;
        }
        n11 += this.evaluateNumbers(n8, n7);
        n11 += this.evaluateNumbers(n6, n5);
        n11 += this.evaluateNumbers(n4, n3);
        return n11 += this.evaluateNumbers(n2, n);
    }

    void illuminateLine(int n) {
        if (n < 16) {
            for (int i = 0; i < 4; ++i) {
                int n2 = n / 4 * 16 + n % 4 * 4 + i;
                this.perlArrayRepresentation[n2] = (char)(this.perlArrayRepresentation[n2] + 2);
                this.refreshPerls();
            }
            return;
        }
        if (n < 32) {
            n -= 16;
            for (int i = 0; i < 4; ++i) {
                int n3 = n / 4 * 16 + n % 4 + i * 4;
                this.perlArrayRepresentation[n3] = (char)(this.perlArrayRepresentation[n3] + 2);
                this.refreshPerls();
            }
            return;
        }
        if (n < 48) {
            n -= 32;
            for (int i = 0; i < 4; ++i) {
                int n4 = n / 4 + n % 4 * 4 + i * 16;
                this.perlArrayRepresentation[n4] = (char)(this.perlArrayRepresentation[n4] + 2);
                this.refreshPerls();
            }
            return;
        }
        if (n < 52) {
            n -= 48;
            for (int i = 0; i < 4; ++i) {
                int n5 = n * 4 + i * 16 + i;
                this.perlArrayRepresentation[n5] = (char)(this.perlArrayRepresentation[n5] + 2);
                this.refreshPerls();
            }
            return;
        }
        if (n < 56) {
            n -= 52;
            for (int i = 0; i < 4; ++i) {
                int n6 = n * 4 + (3 - i) * 16 + i;
                this.perlArrayRepresentation[n6] = (char)(this.perlArrayRepresentation[n6] + 2);
                this.refreshPerls();
            }
            return;
        }
        if (n < 60) {
            n -= 56;
            for (int i = 0; i < 4; ++i) {
                int n7 = n + i * 16 + i * 4;
                this.perlArrayRepresentation[n7] = (char)(this.perlArrayRepresentation[n7] + 2);
                this.refreshPerls();
            }
            return;
        }
        if (n < 64) {
            n -= 60;
            for (int i = 0; i < 4; ++i) {
                int n8 = n + (3 - i) * 16 + i * 4;
                this.perlArrayRepresentation[n8] = (char)(this.perlArrayRepresentation[n8] + 2);
                this.refreshPerls();
            }
            return;
        }
        if (n < 68) {
            n -= 64;
            for (int i = 0; i < 4; ++i) {
                int n9 = n * 16 + i * 4 + i;
                this.perlArrayRepresentation[n9] = (char)(this.perlArrayRepresentation[n9] + 2);
                this.refreshPerls();
            }
            return;
        }
        if (n < 72) {
            n -= 68;
            for (int i = 0; i < 4; ++i) {
                int n10 = n * 16 + (3 - i) * 4 + i;
                this.perlArrayRepresentation[n10] = (char)(this.perlArrayRepresentation[n10] + 2);
                this.refreshPerls();
            }
            return;
        }
        if (n < 73) {
            for (int i = 0; i < 4; ++i) {
                int n11 = i * 16 + i * 4 + i;
                this.perlArrayRepresentation[n11] = (char)(this.perlArrayRepresentation[n11] + 2);
                this.refreshPerls();
            }
            return;
        }
        if (n < 74) {
            for (int i = 0; i < 4; ++i) {
                int n12 = (3 - i) * 16 + i * 4 + i;
                this.perlArrayRepresentation[n12] = (char)(this.perlArrayRepresentation[n12] + 2);
                this.refreshPerls();
            }
            return;
        }
        if (n < 75) {
            for (int i = 0; i < 4; ++i) {
                int n13 = i * 16 + i * 4 + (3 - i);
                this.perlArrayRepresentation[n13] = (char)(this.perlArrayRepresentation[n13] + 2);
                this.refreshPerls();
            }
            return;
        }
        if (n < 76) {
            for (int i = 0; i < 4; ++i) {
                int n14 = (3 - i) * 16 + i * 4 + (3 - i);
                this.perlArrayRepresentation[n14] = (char)(this.perlArrayRepresentation[n14] + 2);
                this.refreshPerls();
            }
            return;
        }
        System.out.println("Line number unknown...");
    }

    private int evaluateNumbers(int n, int n2) {
        int n3 = 0;
        block0 : switch (n2) {
            case 0: {
                switch (n) {
                    case 0: {
                        n3 = 0;
                        break;
                    }
                    case 1: {
                        n3 = -16;
                        break;
                    }
                    case 2: {
                        n3 = -4096;
                        break;
                    }
                    case 3: {
                        n3 = -1048576;
                    }
                }
                break;
            }
            case 1: {
                switch (n) {
                    case 0: {
                        n3 = 1;
                        break block0;
                    }
                }
                n3 = 0;
                break;
            }
            case 2: {
                switch (n) {
                    case 0: {
                        n3 = 256;
                        break block0;
                    }
                }
                n3 = 0;
                break;
            }
            case 3: {
                switch (n) {
                    case 0: {
                        n3 = 65536;
                        break block0;
                    }
                }
                n3 = 0;
            }
        }
        return n3;
    }

    private int maxMinAlphaBeta(int n, char[] cArray, int n2, int n3) {
        if (n == 0) {
            return this.evaluationFunction(cArray);
        }
        if (this.evaluationFunction(cArray) == -268435456) {
            return -268435456;
        }
        int n4 = -268435456;
        char[] cArray2 = new char[64];
        for (int i = 0; i < 16; ++i) {
            cArray2 = (char[])cArray.clone();
            int n5 = 0;
            int n6 = i + n5 * 16;
            boolean bl = false;
            if (n5 < 4 && cArray2[i + n5 * 16] != '\u0000') {
                bl = true;
            }
            while (bl) {
                bl = false;
                if (++n5 >= 4 || cArray2[i + n5 * 16] == '\u0000') continue;
                bl = true;
            }
            if (n5 >= 4) continue;
            cArray2[i + n5 * 16] = 2;
            int n7 = this.minMaxAlphaBeta(n - 1, cArray2, n4, n3);
            if (n7 > n3) {
                return n7;
            }
            if (n7 <= n4) continue;
            n4 = n7;
        }
        return n4;
    }

    private int minMaxAlphaBeta(int n, char[] cArray, int n2, int n3) {
        if (n == 0) {
            return this.evaluationFunction(cArray);
        }
        if (this.evaluationFunction(cArray) == 0x1000000) {
            return 0x1000000;
        }
        int n4 = 0x1000000;
        char[] cArray2 = new char[64];
        for (int i = 0; i < 16; ++i) {
            cArray2 = (char[])cArray.clone();
            int n5 = 0;
            boolean bl = false;
            if (n5 < 4 && cArray2[i + n5 * 16] != '\u0000') {
                bl = true;
            }
            while (bl) {
                bl = false;
                if (++n5 >= 4 || cArray2[i + n5 * 16] == '\u0000') continue;
                bl = true;
            }
            if (n5 >= 4) continue;
            cArray2[i + n5 * 16] = '\u0001';
            int n6 = this.maxMinAlphaBeta(n - 1, cArray2, n2, n4);
            if (n6 < n2) {
                return n6;
            }
            if (n6 >= n4) continue;
            n4 = n6;
        }
        return n4;
    }
}

